% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probeInteraction.R
\name{probe3WayRC}
\alias{probe3WayRC}
\title{Probing three-way interaction on the residual-centered latent interaction}
\usage{
probe3WayRC(fit, nameX, nameY, modVar, valProbe1, valProbe2, group,
  omit.imps = c("no.conv", "no.se"))
}
\arguments{
\item{fit}{A fitted \code{\linkS4class{lavaan}} or
\code{\linkS4class{lavaan.mi}} object with a latent 2-way interaction.}

\item{nameX}{\code{character} vector of all 7 factor names used as the
predictors. The 3 lower-order factors must be listed first, followed by
the 3 second-order factors (specifically, the 4th element must be the
interaction between the factors listed first and second, the 5th element
must be the interaction between the factors listed first and third, and
the 6th element must be the interaction between the factors listed second
and third). The final name will be the factor representing the 3-way
interaction.}

\item{nameY}{The name of factor that is used as the dependent variable.}

\item{modVar}{The name of two factors that are used as the moderators. The
effect of the independent factor on each combination of the moderator
variable values will be probed.}

\item{valProbe1}{The values of the first moderator that will be used to
probe the effect of the independent factor.}

\item{valProbe2}{The values of the second moderator that will be used to
probe the effect of the independent factor.}

\item{group}{In multigroup models, the label of the group for which the
results will be returned. Must correspond to one of
\code{\link[lavaan]{lavInspect}(fit, "group.label")}.}

\item{omit.imps}{\code{character} vector specifying criteria for omitting
imputations from pooled results. Ignored unless \code{fit} is of
class \code{\linkS4class{lavaan.mi}}. Can include any of
\code{c("no.conv", "no.se", "no.npd")}, the first 2 of which are the
default setting, which excludes any imputations that did not
converge or for which standard errors could not be computed.  The
last option (\code{"no.npd"}) would exclude any imputations which
yielded a nonpositive definite covariance matrix for observed or
latent variables, which would include any "improper solutions" such
as Heywood cases.  NPD solutions are not excluded by default because
they are likely to occur due to sampling error, especially in small
samples.  However, gross model misspecification could also cause
NPD solutions, users can compare pooled results with and without
this setting as a sensitivity analysis to see whether some
imputations warrant further investigation.}
}
\value{
A list with two elements:
\enumerate{
 \item \code{SimpleIntercept}: The intercepts given each value of the moderator.
   This element will be shown only if the factor intercept is estimated
   (e.g., not fixed as 0).
 \item \code{SimpleSlope}: The slopes given each value of the moderator.
}
In each element, the first column represents values of the first moderator
specified in the \code{valProbe1} argument. The second column represents
values of the second moderator specified in the \code{valProbe2} argument.
The third column is the simple intercept or simple slope. The fourth column
is the \emph{SE} of the simple intercept or simple slope. The fifth column
is the Wald (\emph{z}) statistic. The sixth column is the \emph{p} value
testing whether the simple intercepts or slopes are different from 0.
}
\description{
Probing interaction for simple intercept and simple slope for the
residual-centered latent three-way interaction (Geldhof et al., 2013)
}
\details{
Before using this function, researchers need to make the products of the
indicators between the first-order factors and residualize the products by
the original indicators (Lance, 1988; Little, Bovaird, & Widaman, 2006). The
process can be automated by the \code{\link{indProd}} function. Note that
the indicator products can be made for all possible combination or
matched-pair approach (Marsh et al., 2004). Next, the hypothesized model
with the regression with latent interaction will be used to fit all original
indicators and the product terms (Geldhof et al., 2013). To use this
function the model must be fit with a mean structure. See the example for
how to fit the product term below. Once the lavaan result is obtained, this
function will be used to probe the interaction.

The probing process on residual-centered latent interaction is based on
transforming the residual-centered result into the no-centered result. See
Geldhof et al. (2013) for further details. Note that this approach based on
a strong assumption that the first-order latent variables are normally
distributed. The probing process is applied after the no-centered result
(parameter estimates and their covariance matrix among parameter estimates)
has been computed. See the \code{\link{probe3WayMC}} for further details.
}
\examples{

library(lavaan)

dat3wayRC <- orthogonalize(dat3way, 1:3, 4:6, 7:9)

model3 <- "
f1 =~ x1 + x2 + x3
f2 =~ x4 + x5 + x6
f3 =~ x7 + x8 + x9
f12 =~ x1.x4 + x2.x5 + x3.x6
f13 =~ x1.x7 + x2.x8 + x3.x9
f23 =~ x4.x7 + x5.x8 + x6.x9
f123 =~ x1.x4.x7 + x2.x5.x8 + x3.x6.x9
f4 =~ x10 + x11 + x12
f4 ~ f1 + f2 + f3 + f12 + f13 + f23 + f123
f1 ~~ 0*f12
f1 ~~ 0*f13
f1 ~~ 0*f123
f2 ~~ 0*f12
f2 ~~ 0*f23
f2 ~~ 0*f123
f3 ~~ 0*f13
f3 ~~ 0*f23
f3 ~~ 0*f123
f12 ~~ 0*f123
f13 ~~ 0*f123
f23 ~~ 0*f123
x1 ~ 0*1
x4 ~ 0*1
x7 ~ 0*1
x10 ~ 0*1
x1.x4 ~ 0*1
x1.x7 ~ 0*1
x4.x7 ~ 0*1
x1.x4.x7 ~ 0*1
f1 ~ NA*1
f2 ~ NA*1
f3 ~ NA*1
f12 ~ NA*1
f13 ~ NA*1
f23 ~ NA*1
f123 ~ NA*1
f4 ~ NA*1
"

fitRC3way <- sem(model3, data = dat3wayRC, std.lv = FALSE,
                 meanstructure = TRUE)
summary(fitRC3way)

probe3WayMC(fitRC3way, nameX = c("f1" ,"f2" ,"f3",
                                 "f12","f13","f23", # the order matters!
                                 "f123"),           # 3-way interaction
            nameY = "f4", modVar = c("f1", "f2"),
            valProbe1 = c(-1, 0, 1), valProbe2 = c(-1, 0, 1))

}
\references{
Geldhof, G. J., Pornprasertmanit, S., Schoemann, A., & Little,
T. D. (2013). Orthogonalizing through residual centering: Extended
applications and caveats. \emph{Educational and Psychological Measurement,
73}(1), 27--46. doi:10.1177/0013164412445473

Lance, C. E. (1988). Residual centering, exploratory and confirmatory
moderator analysis, and decomposition of effects in path models containing
interactions. \emph{Applied Psychological Measurement, 12}(2), 163--175.
doi:10.1177/014662168801200205

Little, T. D., Bovaird, J. A., & Widaman, K. F. (2006). On the merits of
orthogonalizing powered and product terms: Implications for modeling
interactions. \emph{Structural Equation Modeling, 13}(4), 497--519.
doi:10.1207/s15328007sem1304_1

Marsh, H. W., Wen, Z., & Hau, K. T. (2004). Structural equation models of
latent interactions: Evaluation of alternative estimation strategies and
indicator construction. \emph{Psychological Methods, 9}(3), 275--300.
doi:10.1037/1082-989X.9.3.275

Pornprasertmanit, S., Schoemann, A. M., Geldhof, G. J., & Little, T. D.
(submitted). \emph{Probing latent interaction estimated with a residual
centering approach.}
}
\seealso{
\itemize{
 \item \code{\link{indProd}} For creating the indicator products with no
  centering, mean centering, double-mean centering, or residual centering.
 \item \code{\link{probe2WayMC}} For probing the two-way latent interaction
  when the results are obtained from mean-centering, or double-mean centering
 \item \code{\link{probe3WayMC}} For probing the three-way latent interaction
  when the results are obtained from mean-centering, or double-mean centering
 \item \code{\link{probe2WayRC}} For probing the two-way latent interaction
  when the results are obtained from residual-centering approach.
 \item \code{\link{plotProbe}} Plot the simple intercepts and slopes of the
  latent interaction.
}
}
\author{
Sunthud Pornprasertmanit (\email{psunthud@gmail.com})

Terrence D. Jorgensen (University of Amsterdam; \email{TJorgensen314@gmail.com})
}
