% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectSNPs_utility.R
\docType{methods}
\name{scoreE}
\alias{scoreE}
\alias{scoreE,Chrom-method}
\alias{scoreE,Chrom-methods}
\alias{scoreE,Map-method}
\title{Compute the E score}
\usage{
scoreE(object, ...)

\S4method{scoreE}{Chrom}(object)

\S4method{scoreE}{Map}(object, chrom)
}
\arguments{
\item{object}{An input object, which can be a vector of map positions, a Chrom object, or a Map object.}

\item{...}{Extra input parameters, as needed.}

\item{chrom}{Names of the chromosomes for which the E score is to be computed; Optional.}
}
\value{
The computed E score of the input object.
}
\description{
This function computes the average Shannon entropy (E score) as a measure of information
 for all the markers on one or more chromosome.
}
\examples{
data(bov80K)
scoreE(bov80K)

}
\references{
{
1. Wu XL, Li H, Ferretti R, Simpson B, Walker J, Parham J, Mastro L, Qiu J, Schultz T, Tait RG Jr, Bauck S, 
(2010). A unified local objective function for optimally selecting SNPs on arrays for agricultural genomics 
applications. Anim Genet. 2020 Jan 31. doi: 10.1111/age.12916.

2. Wu XL, Xu J, Feng G, Wiggans GR, Taylor JF, He J, Qian C, Qiu J, Simpson B, Walker J, Bauck S. (2016) 
Optimal Design of Low-Density SNP Arrays for Genomic Prediction: Algorithm and Applications. PLoS One. 
11(9):0161719. doi: 10.1371/journal.pone.0161719.
}
}
\author{
Nick X-L Wu
}
