% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selac.R
\name{GetFunctionality}
\alias{GetFunctionality}
\title{Calculate functionality}
\usage{
GetFunctionality(gene.length, aa.data, optimal.aa, alpha, beta, gamma,
  gp = NULL, aa.properties = NULL)
}
\arguments{
\item{gene.length}{Indicates the length of the gene used to calculate functionality.}

\item{aa.data}{A matrix of amino acids}

\item{optimal.aa}{A vector of inferred optimal amino acids.}

\item{alpha}{The inferred Grantham composition paramter}

\item{beta}{The inferred Grantham polarity parameter}

\item{gamma}{The inferred Grantham molecular volume parameter}

\item{gp}{A vector of gamma rates for calculating among site hetergeneity in functionality.}

\item{aa.properties}{User-supplied amino acid distance properties. By default we assume Grantham (1974) properties.}
}
\description{
Calculates the functionality of a single gene
}
\details{
The purpose of this function is to provide the functionality of a gene based on the inferred parameters from SelAC. The functionality is often used to scale phi.
}
