% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rscripts.R
\name{simf1g}
\alias{simf1g}
\title{Simulate genotype counts from F1 individuals}
\usage{
simf1g(n, g1, g2, alpha = 0, xi1 = 1/3, xi2 = 1/3)
}
\arguments{
\item{n}{Sample size.}

\item{g1}{The first parent's genotype.}

\item{g2}{The second parent's genotype.}

\item{alpha}{The double reduction rate.}

\item{xi1}{The first parent's preferential pairing parameter.}

\item{xi2}{The second parent's preferential pairing parameter.}
}
\value{
A vector of counts, where element \code{i} is the number of
simulated individuals with genotype \code{i-1}.
}
\description{
Simulate genotype counts from F1 individuals
}
\examples{
set.seed(1)
simf1g(n = 10, g1 = 1, g2 = 2)

}
\author{
David Gerard
}
