pdf("chp11/img/bioavailable.pdf",height=4,width=4)
# equilibrium constant
K <- 1.56*10^(-10)
# seq of chloride in mM
Cl.mM <- seq(10,100,10)
# convert to M
Cl <- Cl.mM*10^(-3)
# calculate Ag ion
Ag <- K/Cl
# convert to pM
Ag.pM <- Ag*10^12
plot(Cl.mM,Ag.pM, type="l", ylim=c(0,max(Ag.pM)),
     xlab="Cl- in mM", ylab="Ag+ in uM")
cbind(Cl.mM,Ag.pM)
dev.off()


# calculate conc in water given cl
Agtotal <- 0.1
# chloride
Cl <- c(70,80,90)
perc.avail <- 81 - 0.67 * Cl
Cw <- (perc.avail/100) * Agtotal

 
