% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/users.R
\name{add_github_user}
\alias{add_github_user}
\title{Add a user via their GitHub username.}
\usage{
add_github_user(github_user, email = NULL, vault = NULL, i = 1)
}
\arguments{
\item{github_user}{User name on GitHub.}

\item{email}{Email address of the github user. If NULL, constructs an
email as \code{github-<<github_user>>}}

\item{vault}{Vault location (starting point to find the vault).
To create a vault, use \code{\link[=create_vault]{create_vault()}} or \code{\link[=create_package_vault]{create_package_vault()}}.
If this is \code{NULL}, then \code{secret} tries to find the vault automatically:
\itemize{
\item If the \code{secret.vault} option is set to path, that is used as the
starting point.
\item Otherwise, if the \code{R_SECRET_VAULT} environment variable is set to a
path, that is used as a starting point.
\item Otherwise the current working directory is used as the starting
point.
}

If the starting point is a vault, that is used. Otherwise, if the
starting point is in a package tree, the \code{inst/vault} folder is used
within the package. If no vault can be found, an error is thrown.}

\item{i}{Integer, indicating which GitHub key to use (if more than one
GitHub key exists).}
}
\description{
On GitHub, a user can upload multiple keys. This function will download
the first key by default, but you can change this
}
\examples{
vault <- file.path(tempdir(), ".vault")
create_vault(vault)

add_github_user("hadley", vault = vault)
list_users(vault = vault)
delete_user("github-hadley", vault = vault)
}
\seealso{
\code{\link[=add_travis_user]{add_travis_user()}}

Other user functions: \code{\link{add_travis_user}},
  \code{\link{add_user}}, \code{\link{delete_user}},
  \code{\link{list_users}}
}
