% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kw.R
\name{kw}
\alias{kw}
\title{Kruskall Wallis test}
\usage{
kw(x, freq = NA, diff = T, residuals = F, autoarima = T)
}
\arguments{
\item{x}{time series}

\item{freq}{Frequency of the time series}

\item{diff}{Shall the differenced series be tested?}

\item{residuals}{Shall the residuals of an ARIMA model be tested?}

\item{autoarima}{Use automatic instead of a (0,1,1) ARIMA model?}
}
\description{
Test for seasonality in a time series.
}
\details{
If residuals=FALSE the autoarima settings are ignored.

If residuals=TRUE, a non-seasonal ARIMA model is estimated for the time series. And the residuals of the fitted model are used as input to the test statistic. If an automatic order selection is used, the Hyndman-Khandakar algorithm is employed with max(p)=max(q) <= 3.
}
\examples{
kw(ts(rnorm(120, 10,10), frequency=12))
kw(ts(rnorm(1200, 10,10), frequency=7))
}
\references{
Hyndman, R. J. and Y. Khandakar (2008). Automatic Time Series Forecasting: The forecast Package for R. Journal of Statistical Software 27 (3), 1-22.

Kruskal, W. H. and W. A.Wallis (1952). Use of Ranks in One-Criterion Variance Analysis. Journal of the American Statistical Association 47 (260), 583-621.
}
\author{
Daniel Ollech
}
