% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moran_test.R
\name{moran_test}
\alias{moran_test}
\title{test global spatial autocorrelation}
\usage{
moran_test(sfj, wt = NULL, alternative = "greater", symmetrize = FALSE)
}
\arguments{
\item{sfj}{An \code{sf} object or can be converted to \code{sf} by \code{sf::st_as_sf()}.}

\item{wt}{(optional) Spatial weight matrix. Must be a \code{matrix} class. If \code{wt} is not
provided, \code{sdsfun} will use a first-order queen adjacency binary matrix.}

\item{alternative}{(optional) Specification of alternative hypothesis as \code{greater} (default),
\code{lower}, or \code{two.sided}.}

\item{symmetrize}{(optional) Whether or not to symmetrize the asymmetrical spatial weight matrix
\emph{\strong{wt}} by: 1/2 * (\emph{\strong{wt}} + \emph{\strong{wt}}'). Default is \code{FALSE}.}
}
\value{
A list with \code{moran_test} class and result stored on the \code{result} tibble.
Which contains the following information for each variable:
\describe{
\item{\code{MoranI}}{observed value of the Moran coefficient}
\item{\code{EI}}{expected value of Moran's I}
\item{\code{VarI}}{variance of Moran's I (under normality)}
\item{\code{ZI}}{standardized Moran coefficient}
\item{\code{PI}}{\emph{p}-value of the test statistic}
}
}
\description{
Spatial autocorrelation test based on global moran index.
}
\note{
This is a \verb{C++} implementation of the \code{MI.vec} function in \code{spfilteR} package,
and embellishes the console output.

The return result of this function is actually a \code{list}, please access the result
tibble using \verb{$result}.

The non-numeric columns of the attribute columns in \code{sfj} are ignored.
}
\examples{
gzma = sf::read_sf(system.file('extdata/gzma.gpkg',package = 'sdsfun'))
moran_test(gzma)

}
