% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/etp.R
\name{etp}
\alias{etp}
\title{Educational Testing Problem}
\usage{
etp(B)
}
\arguments{
\item{B}{A symmetric positive definite matrix}
}
\value{
\item{X}{A list containing the solution matrix to the primal problem}
\item{y}{A list containing the  solution vector to the dual problem}
\item{Z}{A list containing the  solution matrix to the dual problem}
\item{pobj}{The achieved value of the primary objective function}
\item{dobj}{The achieved value of the dual objective function}
}
\description{
\code{etp} creates input for sqlp to solve the Educational Testing Problem -
given a symmetric positive definite matrix S, how much can be subtracted from the diagonal
elements of S such that the resulting matrix is positive semidefinite definite.
}
\details{
Solves the education testing problem. Mathematical and implementation
details can be found in the vignette
}
\examples{
data(Betp)

out <- etp(Betp)

}
