% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smat.R
\name{smat}
\alias{smat}
\title{Create a Symmetrix Matrix}
\usage{
smat(blk, p, At, isspM = NULL)
}
\arguments{
\item{blk}{Lx2 matrix detailing the type of matrices ("s", "q", "l", "p"), and the size of each matrix}

\item{p}{Row of blk to be used during matrix creation}

\item{At}{vector to be turned into a symmetric matrix}

\item{isspM}{if At is sparse, isspx = 1, 0 otherwise. Default is to assume M is dense.}
}
\value{
\item{M}{A Symmetric Matrix}
}
\description{
\code{smat} takes a vector and creates a symmetrix matrix
}
\examples{

y <- c(1,0.00000279, 3.245, 2.140, 2.44, 2.321, 4.566)

blk <- matrix(list(),1,2)
blk[[1,1]] <- "s"
blk[[1,2]] <- 3

P <- smat(blk,1, y)

}

