% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/protect_quadtree.R
\name{protect_quadtree}
\alias{protect_quadtree}
\title{Protect a raster with  a quadtree method.}
\usage{
protect_quadtree(x, max_zoom = Inf, ...)
}
\arguments{
\item{x}{\code{\link{sdc_raster}} object to be protected.}

\item{max_zoom}{\code{numeric}, restricts the number of zoom steps and thereby the max resolution for the
blocks. Each step will zoom with a factor of 2 in x and y so the max resolution = resolution * 2^max_zoom.}

\item{...}{Arguments passed on to \code{is_sensitive}
\describe{
  \item{x}{\code{\link{sdc_raster}} object.}
  \item{max_risk}{a risk value higher than \code{max_risk} will be sensitive.}
  \item{min_count}{a count lower than \code{min_count} will be sensitive.}
  \item{risk_type}{what kind of measure should be used (see details).}
}}
}
\value{
a \code{\link{sdc_raster}} object, in which sensitive cells have been recursively aggregated until not sensitive or
when max_zoom has been reached.
}
\description{
\code{protect_quadtree} reduces sensitivy by aggregating sensisitve cells with its
three neighbors, and does this recursively until no sensitive cells are
left or when the maximum zoom levels has been reached.
}
\details{
This implementation generalizes the method as described by Suñé et al., in
which there is no
risk function, and only a  \code{min_count} to determine sensitivity.
Furthermore the method the article
only handles count data (\code{x$value$count}), not mean or summed values.
Currently the translation feature of the article is not (yet) implemented,
for the original method does not take the \code{disclosure_risk} into account.
}
\examples{
library(raster)

fined <- sdc_raster(enterprises, enterprises$fined)
plot(fined)
fined_qt <- protect_quadtree(fined)
plot(fined_qt)

fined <- sdc_raster(enterprises, enterprises$fined, r=50)
plot(fined)
fined_qt <- protect_quadtree(fined)
plot(fined_qt)

}
\references{
Suñé, E., Rovira, C., Ibáñez, D., Farré, M. (2017).
Statistical disclosure control on visualising geocoded population data using
a structure in quadtrees, NTTS 2017
}
\seealso{
Other protection methods: \code{\link{protect_smooth}},
  \code{\link{remove_sensitive}}
}
\concept{protection methods}
