% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shuffle.R
\docType{methods}
\name{shuffle}
\alias{shuffle}
\title{Shuffling and EGADP}
\usage{
shuffle(
  obj,
  form,
  method = "ds",
  weights = NULL,
  covmethod = "spearman",
  regmethod = "lm",
  gadp = TRUE
)
}
\arguments{
\item{obj}{An object of class sdcMicroObj or a data.frame including the
data.}

\item{form}{An object of class \dQuote{formula} (or one that can be coerced
to that class): a symbolic description of the model to be fitted.  The
responses have to consists of at least two variables of any class and the
response variables have to be of class numeric.  The response variables
belongs to numeric key variables (quasi-identifiers of numeric scale). The
predictors are can be distributed in any way (numeric, factor, ordered
factor).}

\item{method}{currently either the original form of data shuffling
(\dQuote{ds} - default), \dQuote{mvn} or \dQuote{mlm}, see the details
section. The last method is in experimental mode and almost untested.}

\item{weights}{Survey sampling weights. Automatically chosen when obj is of
class \code{\link{sdcMicroObj-class}}.}

\item{covmethod}{Method for covariance estimation. \dQuote{spearman},
\dQuote{pearson} and \ dQuotemcd are possible. For the latter one, the
implementation in package robustbase is used.}

\item{regmethod}{Method for multivariate regression. \dQuote{lm} and
\dQuote{MM} are possible.  For method \dQuote{MM}, the function \dQuote{rlm}
from package MASS is applied.}

\item{gadp}{TRUE, if the egadp results from a fit on the origianl data is
returned.}
}
\value{
If \sQuote{obj} is of class \code{\link{sdcMicroObj-class}} the corresponding
slots are filled, like manipNumVars, risk and utility.  If \sQuote{obj} is
of class \dQuote{data.frame} an object of class \dQuote{micro} with
following entities is returned: \item{shConf }{the shuffled numeric key
variables} \item{egadp }{the perturbed (using gadp method) numeric key
variables}
}
\description{
Data shuffling and General Additive Data Perturbation.
}
\details{
Perturbed values for the sensitive variables are generated.  The sensitive
variables have to be stored as responses in the argument \sQuote{form},
which is the usual formula interface for regression models in R.

For method \dQuote{ds} the EGADP method is applied on the norm inverse
percentiles.  Shuffling then ranks the original values according to the GADP
output. For further details, please see the references.

Method \dQuote{mvn} uses a simplification and draws from the normal Copulas
directly before these draws are shuffled.

Method \dQuote{mlm} is also a simplification. A linear model is applied the
expected values are used as the perturbed values before shuffling is
applied.
}
\note{
In this version, the covariance method chosen is used for any
covariance and correlation estimations in the whole gadp and shuffling
function.
}
\examples{
data(Prestige,package="carData")
form <- formula(income + education ~ women + prestige + type, data=Prestige)
sh <- shuffle(obj=Prestige,form)
plot(Prestige[,c("income", "education")])
plot(sh$sh)
colMeans(Prestige[,c("income", "education")])
colMeans(sh$sh)
cor(Prestige[,c("income", "education")], method="spearman")
cor(sh$sh, method="spearman")

## for objects of class sdcMicro:
data(testdata2)
sdc <- createSdcObj(testdata2,
  keyVars=c('urbrur','roof','walls','water','electcon','relat','sex'),
  numVars=c('expend','income','savings'), w='sampling_weight')
sdc <- shuffle(sdc, method=c('ds'),regmethod= c('lm'), covmethod=c('spearman'),
		form=savings+expend ~ urbrur+walls)
}
\references{
K. Muralidhar, R. Parsa, R. Saranthy (1999). A general additive
data perturbation method for database security. \emph{Management Science},
45, 1399-1415.

K. Muralidhar, R. Sarathy (2006). Data shuffling - a new masking approach
for numerical data. \emph{Management Science}, 52(5), 658-670, 2006.

M. Templ, B. Meindl. (2008).  Robustification of Microdata Masking Methods
and the Comparison with Existing Methods, in: \emph{Lecture Notes on
Computer Science}, J. Domingo-Ferrer, Y. Saygin (editors.); Springer,
Berlin/Heidelberg, 2008, ISBN: 978-3-540-87470-6, pp. 14-25.
}
\seealso{
\code{\link{rankSwap}, \link{lm}}
}
\author{
Matthias Templ, Alexander Kowarik, Bernhard Meindl
}
\keyword{manip}
