% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hyperpar.r
\name{hyperpar}
\alias{hyperpar}
\title{Find Scale Parameters for Inverse Gamma Hyperprior of Nonlinear Effects with Spike and Slab Prior (Simulation-based)}
\usage{
hyperpar(Z, Kinv, a = 5, c = 0.1, alpha1 = 0.1, alpha2 = 0.1,
  R = 10000, myseed = 123)
}
\arguments{
\item{Z}{the row of the design matrix (or the complete matrix of several observations) evaluated at.}

\item{Kinv}{the generalised inverse of \eqn{K}.}

\item{a}{is the shape parameter of the inverse gamma distribution, default is 5.}

\item{c}{denotes the expected range of eqn{f} .}

\item{alpha1}{denotes the 1-\eqn{\alpha1} level for \eqn{b}.}

\item{alpha2}{denotes the 1-\eqn{\alpha2} level for \eqn{r}.}

\item{R}{denotes the number of replicates drawn during simulation.}

\item{myseed}{denotes the required seed for the simulation based method.}
}
\value{
an object of class \code{list} with root values \eqn{r}, \eqn{b} from \code{\link{uniroot}}.
}
\description{
This function implements a optimisation routine that computes the scale parameter \eqn{b} and selection parameter
\eqn{r}. . Here, we assume an inverse gamma prior IG(\eqn{a},\eqn{b}) for \eqn{\psi^2} and \eqn{\tau^2\sim N(0,r(\delta)\psi^2)} 
and given shape paramter \eqn{a},
such that approximately \eqn{P(f(x)\le c|spike,\forall x\in D)\ge 1-\alpha1} and \eqn{P(\exists x\in D s.t. f(x)\ge c|slab)\ge 1-\alpha2}.
}
\examples{
set.seed(123)
library(MASS)
# prior precision matrix (second order differences) 
# of a spline of degree l=3 and with m=22 inner knots
# yielding dim(K)=m+l-1=22
K <- t(diff(diag(22), differences=2))\%*\%diff(diag(22), differences=2)
# generalised inverse of K (same as if we used mixed model representation!)
Kinv <- ginv(K)
# covariate x
x <- runif(1)
Z <- matrix(DesignM(x)$Z_B,nrow=1)
fgrid <- seq(-3,3,length=1000)
mdf <- hyperpar(Z,Kinv,a=5,c=0.1,alpha1=0.05,alpha2=0.05,R=10000,myseed=123)

}
\references{
Nadja Klein, Thomas Kneib, Stefan Lang and Helga Wagner (2016). Spike and Slab Priors for Effect Selection in Distributional Regression. 
\emph{Working Paper}.
}
\author{
Nadja Klein
}
