.changeClick <-
function(combo, data){
	modes = rgl::par3d()$mouseMode
	button = switch(combo$getName(),
		LeftClick = 1,
		MiddleClick = 2,
		RightClick = 3)
	modes[button] = combo$getActiveText()
	rgl::par3d(mouseMode=modes)
}

.colorSet <-
function(button,data){
	dialog <- RGtk2::gtkColorSelectionDialogNew("Changing color", show=F)

	  dialog$setTransientFor(.local$gWidget)
	  
	  colorsel <- dialog[["colorsel"]]
	  
	  colorsel$setHasPalette(TRUE)
	  
	  response <- dialog$run()
	  if (response == GtkResponseType["ok"])
	    {
	      color <- colorsel$getCurrentColor()$color
		  sel_color = unlist(lapply(color,function(x){x/2^16}))[2:4]
		  sel_color = rgb(sel_color[1], sel_color[2], sel_color[3])
		
		  .local$selected_color <- sel_color
	      # save the color in the graphics context
	      .local$color_swatch$modifyBg("normal", color)
	    }
	  		
	  dialog$destroy()
}

.cropData <-
function(button){
	.local$current <- .local$selected & .local$current
	.local$selected = rep(FALSE, length(.local$selected))
	.filterPlot3d()
	.local$crop_button$sensitive = FALSE
	.local$delete_button$sensitive = FALSE
	if (!is.null(.local$callback)) .local$callback(.local$current, .local$selected, .local$selected_color)
}

.deleteData <-
function(button){
	.local$current <- !.local$selected & .local$current
	.local$selected = rep(FALSE, length(.local$selected))	
	.filterPlot3d(.local$current)
	.local$crop_button$sensitive = FALSE
	.local$delete_button$sensitive = FALSE
	if (!is.null(.local$callback)) .local$callback(.local$current, .local$selected, .local$selected_color)
}

.filterPlot3d <-
function(filter_vec = .local$current, col = .local$base_colors, type = .local$type, alpha = .local$alpha, ...){
	.rglCurCheck()
	
	
	if (any(.local$selected)){
		col[.local$selected] = .local$selected_color
	}
	
	rgl::plot3d( 	.local$x[filter_vec], 
					.local$y[filter_vec], 
					.local$z[filter_vec],
					xlab = .local$xlab, ylab = .local$ylab, zlab = .local$zlab,
					radius = .local$radius[filter_vec],
					type=type,
					alpha = alpha[filter_vec],
					col=col[filter_vec],
					size = .local$size,
					...
					)
	selected = .local$selected
	if (!any(selected)) selected = rep(TRUE, length(selected))
	
	if (!is.null(.local$labels) && .local$show_labels ){
		rgl::text3d(.local$x[filter_vec & selected], .local$y[filter_vec & selected], .local$z[filter_vec & selected], 
			text = .local$labels[filter_vec & selected], ...)
	}
	


	
}

.select3dCall <-
function(){
	.local$select_function = rgl::rgl.select3d()
	.local$select3d_button$setActive(FALSE)
	.local$selected <- .local$select_function(.local$x, .local$y, .local$z ) & .local$current
	if (any(.local$selected)) {
		rgl::rgl.pop(id=rgl.ids()[rgl.ids()[,2]=='points',]$id)
		.filterPlot3d()
		.local$crop_button$sensitive = TRUE
		.local$delete_button$sensitive = TRUE
	} else { 
		.local$selected <- rep(FALSE, length(.local$x)) 
	}
	if (!is.null(.local$callback)) .local$callback(.local$current, .local$selected, .local$selected_color)
}



.local <- new.env()
.Random.seed <-
c(403L, 112L, 468004143L, 65218348L, 1522779001L, -1269014994L, 
-1250107727L, 86948430L, 761585495L, 1641285813L, -1860276884L, 
2000480986L, -651155193L, -164994412L, 697247870L, 102188552L, 
2009057840L, 786622403L, -1906263022L, 456684262L, 1150332322L, 
-787736135L, -807532731L, -451855036L, -1311198494L, -1842758796L, 
-1869613464L, -2034278894L, -1195367029L, 236771303L, -450013019L, 
946388399L, -169275039L, -841321694L, -2113267658L, -526898460L, 
-661828785L, 1441562601L, -1019713901L, -1534522412L, -288567999L, 
-1699280623L, 693614912L, 654900466L, -1289743490L, 1829655476L, 
-1580099669L, 417907767L, 615819110L, 1164637539L, -1771217886L, 
589932670L, 161431755L, -47196371L, 2071348269L, 209861642L, 
-42970569L, 829397726L, 2016543692L, 1930125625L, -1308734098L, 
-1111209213L, -298835822L, 1934825964L, -361953682L, 670464058L, 
-448043674L, -411254521L, -1275418224L, 434241383L, 1562725362L, 
1223864824L, 533982537L, 994192086L, 1779448891L, -257850834L, 
1326405400L, 1311575660L, -1179655561L, -849639149L, -1619042791L, 
746933535L, 325916329L, -2100070479L, -1249830398L, 304397717L, 
876217975L, -1348439444L, 1872384182L, 151645481L, -1099182029L, 
-18896031L, 7762825L, -1928371148L, -1664441166L, 108725943L, 
1344717330L, 715180628L, -469973900L, -165291375L, 1308864332L, 
-53833084L, 2055305955L, 1417330184L, 1348871474L, -1366595115L, 
1407886661L, 137171869L, 539804559L, 1948434658L, -584095635L, 
-1384520540L, 806583085L, 704255567L, -2114493344L, -1676901353L, 
1453474756L, -1501430266L, -1927381545L, -1903298867L, -120635866L, 
1633242381L, 212942201L, -598006158L, -540453009L, -365295658L, 
1655132334L, 851742099L, 976677259L, -1087080363L, 313886764L, 
-1531839863L, -932816063L, -1498278910L, 2092433995L, -1995663399L, 
-1234714669L, -1009674798L, 177903769L, -1293793657L, -453939303L, 
-1834998713L, 1976766476L, 1227466500L, 1561257869L, 827976655L, 
28190505L, -361764754L, 1610242926L, 231806236L, 262490308L, 
1967346336L, 1561010444L, 746473200L, 1991791537L, -287799342L, 
114685358L, 1553640543L, 41114973L, 1402681524L, -1658785502L, 
-163985905L, 915409341L, -1199267346L, 875862421L, -1579733863L, 
1140409103L, 1498155271L, -390352656L, -969946164L, -655441603L, 
981553290L, -323046568L, -897639239L, 690104877L, 1451999964L, 
-768034286L, -1698933299L, -1714316571L, 623879063L, 362494758L, 
-1670630095L, -143768286L, -713156364L, -237019871L, 1815066372L, 
-925715597L, 460379723L, 1096965026L, 1911560626L, 250556858L, 
-286097834L, 130360188L, -604489075L, -134680984L, 1169499158L, 
-530095450L, -1664467142L, -1055165452L, 926692198L, 1779523891L, 
882567041L, 1344215990L, 1187544081L, -360826780L, -1771504922L, 
1012938530L, -1654332485L, 1377063348L, -1594280188L, 736058796L, 
-299068808L, -1035813159L, 1223001301L, 1467450387L, 375323757L, 
-1414270616L, -25880166L, -75513202L, 836923586L, -1954334598L, 
-1229265580L, 436945709L, 1560522721L, -345997541L, 1326858987L, 
1867141715L, -1080111234L, 225606477L, -1756461405L, 579083648L, 
1216910974L, -933074379L, -633846360L, 252016746L, 227964029L, 
-1932152963L, 1378065886L, 617372836L, -1675924111L, 1677661452L, 
1808086339L, 539568871L, -886034547L, -674771402L, 709341180L, 
-885482210L, 1257734014L, 1838301901L, -2068452588L, -1265892047L, 
-1425376980L, -1190919511L, 1407988292L, -1425175756L, 556981588L, 
1845142870L, -2090522017L, -1625505371L, 1192541122L, 189456736L, 
1487076411L, -1006921836L, 1198491817L, 600168147L, 994727257L, 
-2119602849L, 170090029L, -694981571L, -248336783L, -1571834004L, 
1786456863L, -23742511L, -91184722L, 1188358164L, -868780729L, 
1571659660L, -622033332L, 1617090073L, 399624663L, -1517362449L, 
-1284922874L, 1502934965L, 100232496L, 1825852445L, -658843827L, 
-742704668L, -7028743L, 1496177917L, -1030076439L, -1837372866L, 
921471553L, -379290239L, -1914365290L, 320288608L, 2010572883L, 
38979291L, 658776518L, 2028837756L, -1751798177L, -740994584L, 
-1110995588L, -1983658827L, -1606879285L, 854399029L, -1352045879L, 
-127574588L, 576469512L, -1924547088L, 344904679L, -71675905L, 
1196501996L, -1136336172L, 1347694872L, 1991217858L, -135117048L, 
-1732742484L, -983675297L, 1073079759L, -1785442326L, 1916072245L, 
-1260111845L, 585869282L, -1236511848L, -224696358L, -747635396L, 
919939291L, 1841391936L, 1652745885L, 1683648678L, 2008663003L, 
109168929L, -670166946L, -841020213L, -1000276989L, 500205827L, 
2089766411L, -2131007344L, 204809935L, 740234134L, -1805178665L, 
1799246119L, 10109955L, -1623203687L, -34090544L, -222470393L, 
-1465308648L, 485315603L, -1812415676L, -1571860533L, 989731751L, 
-1152083811L, -56966993L, 1011374023L, -1572457350L, -1519571754L, 
-1333347102L, -1303983555L, -525130356L, 927273681L, -1242580608L, 
-1820635691L, -208405316L, 2127782946L, 171776335L, -1113146983L, 
1812843782L, -958467137L, 2099278757L, -1389700388L, -1270714405L, 
-52910224L, -75024785L, -1914348315L, 652499533L, -2051296573L, 
-342847110L, -1537922511L, 2127461415L, 832563979L, -1229378169L, 
505998566L, 1758037233L, -732213310L, 28769853L, 1921223957L, 
-1046482037L, -1197166724L, -1294816452L, -551463602L, -945267232L, 
-1493543305L, 645264083L, -606734781L, -1541446139L, 884619579L, 
-2084478513L, -1530138512L, -395815282L, -94725479L, 1583104104L, 
1834060641L, -1976766693L, 1259083009L, -742294082L, -1461001648L, 
1124058486L, -1670929001L, -313315210L, -588787735L, 1247724217L, 
807603875L, 412232539L, -5775614L, 2097227515L, -1200183146L, 
-1091882731L, -1541177532L, -1464206213L, -2054466180L, -1013523065L, 
-698358726L, -221040498L, -2021974572L, -17567438L, -763895686L, 
1478449190L, 334868565L, 1943816665L, -2042692470L, -331109021L, 
1943646085L, 1540546376L, -1900411386L, -1083722166L, -908255276L, 
-1546339306L, -1796091153L, -1106092824L, -2050897475L, 1773032074L, 
-449397566L, 592381077L, -423315185L, -875216261L, -1942127075L, 
-1534145339L, 1016760933L, -1023136329L, -757797534L, 91799359L, 
-1416504793L, 933093995L, 2128872518L, 1414429006L, 2028977700L, 
-1288141348L, 2118458114L, 1058104621L, 264461214L, 2126778077L, 
1643609343L, 1035244301L, -247465846L, -661533194L, 285724272L, 
613020068L, 1126891610L, -1337634655L, 156518905L, 78260312L, 
1837546797L, 177873704L, -835756154L, 1229664226L, 2123167726L, 
939979103L, -1470930015L, -1400087895L, 1848679422L, 634431555L, 
934166324L, -425963419L, -575983447L, -701544277L, 1601448168L, 
-1824753443L, 1213149853L, -1021636232L, -1391081609L, -179452257L, 
-1794614998L, 2099479801L, -544686209L, 1875999894L, 551964957L, 
-1729756897L, 1000656721L, 491216618L, -1989410981L, -349411267L, 
-658234661L, -1734554384L, -1553005046L, 1440667997L, -1214315318L, 
1804640662L, -2033918914L, -2076037112L, -549405355L, 886629266L, 
954677623L, 721726510L, 1465848698L, -1126753058L, 992699772L, 
-505701774L, -1040986903L, 1646914653L, -1707210354L, 610661845L, 
453144767L, -341698763L, -1978893161L, 572084253L, 1238979095L, 
-875532465L, 1352765568L, 1579162116L, -1152271685L, -1400862075L, 
-1991283628L, -276782423L, 1269255366L, 984203531L, -1626599190L, 
536858033L, -2109070789L, -1905506834L, -2137330589L, -1800326953L, 
1848560027L, -1992377295L, -1086761198L, 500538305L, -1418362471L, 
693882887L, -1684519282L, 1351414318L, 1415792960L, 896762541L, 
-1932767120L, -1220920023L, -769741996L, -521855453L, 2107498957L, 
822134101L, -741415821L, 941736219L, -992844021L, -1283988283L, 
-837308682L, 808907062L, 1523402323L, 685981640L, 1203511782L, 
696645724L, -360746208L, 1530385088L, -876355867L, 811254949L, 
-406854280L, -939321943L, 1824548889L, -654653029L, -1818480318L, 
788699862L, -1898750039L, -746938995L, 900283980L, 1840595955L, 
-627399083L, 1349314045L, -960920518L, 355708814L, 185109166L, 
1906603617L, -1260039900L, -179128212L, -1426777487L, -1181593759L, 
1430778010L, 1857921458L, -2067351441L, 707245381L, 1122820114L, 
518186802L, 996121430L, -2035915027L, -2021320331L, 2139698081L, 
1035084422L, -387702926L, 78957930L, -129930706L, -1082379970L, 
2025100254L, 500677293L, 142236751L, -1797072526L, -1701993840L, 
1645764980L, -789738360L, 1846357036L, 19430118L, 871076639L, 
-770422979L, 1626184552L, -442635005L, -365204953L, 1929847381L, 
1652352784L, 394439036L, 610727227L, 1727857063L, 2089971910L
)
.required <-
c("RGtk2", "JGR", "datasets", "utils", "grDevices", "graphics", 
"stats", "methods", "JavaGD", "MASS","rgl")
.resetData <-
function(button,data){
	.local$current <- rep(TRUE, length(.local$current))
	.local$selected <- rep(FALSE, length(.local$current))
	.local$show_labels <- FALSE
	.filterPlot3d(.local$current)
	if (!is.null(.local$callback)) .local$callback(.local$current, .local$selected, .local$selected_color)
}

.rglCurCheck <-
function(){
	if (rgl::rgl.cur() != .local$rgl.cur){
		dialog <- RGtk2::gtkDialog("Lost Focus", NULL, "destroy-with-parent", "gtk-ok", "none", show=FALSE)
		label_str = '"sculpt3d" lost the current rgl output.  It must shut down now.'
		label<-RGtk2::gtkLabel(label_str)
		x = gSignalConnect(dialog,"response", RGtk2::gtkWidgetDestroy)
		dialog[["vbox"]]$add(label)
		dialog$setTransientFor(.local$gWidget)
		response<-dialog$run()
		if (response == GtkResponseType["ok"]) { dialog$destroy() }
		.local$gWidget$destroy();
		stop(label_str)	
	}
}

.selectData <-
function(button,data){
	if (button$getActive()){
		.rglCurCheck()
        rgl::rgl.bringtotop()	
		if(.Platform$GUI == "AQUA"){
		    R = "R"
		    if (Sys.getenv("R_ARCH") == "/x86_64"){
		        R = "R64"
		    }
			system(paste("osascript -e 'tell application \"", R, "\" to activate cmd \"sculpt3d:::.select3dCall()\"'",sep=""))
        } else  .select3dCall()

	}
}

.toggleLabel <-
function(button, data){
	if (button$getActive()){
		.local$show_labels <- TRUE
		.filterPlot3d()
	} else{
		.local$show_labels <- FALSE
		.filterPlot3d()
	}
}

