% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scroll_reveal.R
\name{scroll_reveal}
\alias{scroll_reveal}
\title{Animate elements when scrolling to view them}
\usage{
scroll_reveal(
  target,
  duration = 1000,
  delay = 100,
  distance = "20px",
  origin = "bottom",
  reset = TRUE
)
}
\arguments{
\item{target}{The elements to animate as they scroll into view}

\item{duration}{The duration of the animation in milliseconds. Defaults to 1000 ms}

\item{delay}{The desired delay in milliseconds before triggering the animation. Defaults to 100 ms}

\item{distance}{Controls how far elements move when revealed. Defaults to 20px}

\item{origin}{Specifies what direction elements come from when revealed ("top", "bottom", "right", "left"). Defaults to "bottom"}

\item{reset}{logical, should the function animate the element each time it scrolls into view or only once. Defaults to TRUE.}
}
\value{
An animated shiny element
}
\description{
Animate elements when scrolling to view them
}
\examples{
if (interactive()) {

ui <- fluidPage(
h1("TIME"),
br(),
br(),
h1("SPACE"),
br(),
br(),
h1("PIZZA"),
br(),
br(),
br(), br(), br(), br(), br(), br(), br(), br(), br(), br(), br(), br(), br(), br(),
br(), br(), br(), br(), br(), br(), br(), br(), br(), br(), br(), br(), br(), br(),
br(), br(), br(), br(), br(), br(), br(), br(), br(), br(), br(), br(), br(), br(),
br(), br(), br(), br(), br(), br(), br(), br(), br(), br(), br(), br(), br(), br(),

# Using the scroll_reveal() function
scroll_reveal(target = "h1", duration = 2000, distance = "100px"),

# IMPORTANT! don't forget to set up the scrollrevealR package
use_reveal(),
)
server <- function(input, output) {

}

shinyApp(ui = ui, server = server)
}
}
