% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scregclust.R
\name{split_sample}
\alias{split_sample}
\title{Split Sample}
\usage{
split_sample(
  z,
  stratification,
  is_regulator,
  split_indices,
  split1_proportion,
  total_proportion,
  center
)
}
\arguments{
\item{z}{matrix of single cell data with rows as genes and columns as cells.}

\item{stratification}{a vector by which the sampling will be stratified
of length \code{ncol(z)}}

\item{is_regulator}{an indicator vector, telling which rows in \code{z} are
candidate regulators}

\item{split_indices}{a vector of given split indices. can be \code{NULL}}

\item{split1_proportion}{proportion to include in first data split}

\item{total_proportion}{proportion of data to include overall in splitting}

\item{center}{TRUE if data should be row-centered. Set to FALSE otherwise.}
}
\value{
a list containing
\item{z1_reg}{first data split, TF-part}
\item{z2_reg}{second data split, TF-part}
\item{z1_target}{first data split, non-TF part}
\item{z2_target}{second data split, non-TF part}
\item{split_indices}{either verbatim the vector given as input or
a vector encoding the splits as NA = not included,
1 = split 1 or 2 = split 2. Allows reproducibility
of data splits.}
}
\description{
Splits sample in train and test set
}
\keyword{internal}
