% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-forecast-binary.R,
%   R/class-forecast-nominal.R, R/class-forecast-point.R,
%   R/class-forecast-quantile.R, R/class-forecast-sample.R, R/class-forecast.R
\name{is_forecast_binary}
\alias{is_forecast_binary}
\alias{is_forecast_nominal}
\alias{is_forecast_point}
\alias{is_forecast_quantile}
\alias{is_forecast_sample}
\alias{is_forecast}
\title{Test whether an object is a forecast object}
\usage{
is_forecast_binary(x)

is_forecast_nominal(x)

is_forecast_point(x)

is_forecast_quantile(x)

is_forecast_sample(x)

is_forecast(x)
}
\arguments{
\item{x}{An R object.}
}
\value{
\emph{\code{is_forecast}}: \code{TRUE} if the object is of class \code{forecast},
\code{FALSE} otherwise.

\emph{\verb{is_forecast_<type>*}}: \code{TRUE} if the object is of class \verb{forecast_*} in addition
to class \code{forecast}, \code{FALSE} otherwise.
}
\description{
Test whether an object is a forecast object.

You can test for a specific \verb{forecast_<type>} class using the appropriate
\verb{is_forecast_<type>} function.
}
\examples{
forecast_binary <- as_forecast_binary(example_binary)
is_forecast(forecast_binary)
}
\keyword{validate-forecast-object}
