% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{range_plot}
\alias{range_plot}
\title{Plot Metrics by Range of the Prediction Interval}
\usage{
range_plot(
  scores,
  y = "interval_score",
  x = "model",
  colour = "range",
  xlab = x,
  ylab = y
)
}
\arguments{
\item{scores}{A data.frame of scores based on quantile forecasts as
produced by \code{\link{eval_forecasts}}. Note that "range" must be included
in the \code{summarise_by} argument when running \code{eval_forecasts}}

\item{y}{The variable from the scores you want to show on the y-Axis.
This could be something like "interval_score" (the default) or "sharpness"}

\item{x}{The variable from the scores you want to show on the x-Axis.
Usually this will be "model"}

\item{colour}{Charachter vector of length one used to determine a variable
for colouring dots. The Default is "range".}

\item{xlab}{Label for the x-axis. Default is the variable name on the x-axis}

\item{ylab}{Label for the y-axis. Default is "WIS contributions"}
}
\value{
A ggplot2 object showing a contributions from the three components of
the weighted interval score
}
\description{
Visualise the metrics by range, e.g. if you are interested how different
interval ranges contribute to the overal interval score, or how sharpness
changes by range.
}
\examples{
scores <- scoringutils::eval_forecasts(scoringutils::quantile_example_data_long,
                                       by = c("model", "id", "horizon"),
                                       summarise_by = c("model", "horizon", "range"))
scoringutils::range_plot(scores, x = "model")

scoringutils::range_plot(scores, y = "sharpness", x = "model")
}
