% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores_sample_univ.R
\name{scores_sample_univ}
\alias{scores_sample_univ}
\alias{crps_sample}
\alias{logs_sample}
\title{Scoring Rules for Simulated Forecast Distributions}
\usage{
crps_sample(y, dat, method = "edf", w = NULL, bw = NULL,
  num_int = FALSE, show_messages = TRUE)

logs_sample(y, dat, bw = NULL, show_messages = TRUE)
}
\arguments{
\item{y}{vector of realized values.}

\item{dat}{vector or matrix (depending on \code{y}; see details)
of simulation draws from forecast distribution.}

\item{method}{string; approximation method. Options:
"edf" (empirical distribution function) and
"kde" (kernel density estimation).}

\item{w}{vector or matrix (matching \code{dat}) of weights for method \code{"edf"}.}

\item{bw}{vector (matching \code{y}) of bandwidths for kernel density
estimation; see details.}

\item{num_int}{logical; if TRUE numerical integration is used for method \code{"kde"}.}

\item{show_messages}{logical; display of messages (does not affect
warnings and errors).}
}
\value{
Value of the score. \emph{A lower score indicates a better forecast.}
}
\description{
Calculate scores (CRPS, LogS) given observations and draws from the predictive distributions.
}
\details{
For a vector \code{y} of length n, \code{dat} should be given as a matrix
with n rows. If \code{y} has length 1, then \code{dat} may be a vector.

\code{\link{crps_sample}} employs an empirical version of the quantile
decomposition of the CRPS (Laio and Tamea, 2007) when using
\code{method = "edf"}. For \code{method = "kde"}, it uses kernel density
estimation using a Gaussian kernel. The logarithmic score always uses kernel density estimation.

The bandwidth (\code{bw}) for kernel density estimation can be
specified manually, in which case it must be a positive number. If
\code{bw == NULL}, the bandwidth is selected using the core function
\code{\link{bw.nrd}}. Numerical integration may speed up computation for
\code{\link{crps_sample}} in case of large samples \code{dat}.
}
\examples{
\dontrun{

# y has length greater than 1
y <- 1:2
sample <- matrix(rnorm(20), nrow = 2)
crps_sample(y = y, dat = sample)
logs_sample(y = y, dat = sample)

y <- 1:2
sample <- rnorm(10)
crps_sample(y = y, dat = sample) # error

# y has length 1
y <- 1
sample <- rnorm(10)
crps_sample(y = y, dat = sample)

sample <- matrix(rnorm(10), nrow = 1)
crps_sample(y = y, dat = sample)

sample <- matrix(rnorm(20), nrow = 2)
crps_sample(y = y, dat = sample) # error
}

}
\references{
\emph{Evaluating simulation based forecast distributions:}

Krueger, F., Lerch, S., Thorarinsdottir, T.L. and T. Gneiting (2016):
`Probabilistic forecasting and comparative model assessment based on
Markov Chain Monte Carlo output', working paper,
Heidelberg Institute for Theoretical Studies,
available at \url{http://arxiv.org/abs/1608.06802}.
 
\emph{Empirical quantile decomposition of the CRPS:}
 
Laio, F. and S. Tamea (2007):
`Verification tools for probabilistic forecasts of continuous
hydrological variables',
Hydrology and Earth System Sciences, 11, 1267-1277.
}
\author{
Alexander Jordan, Fabian Krueger, Sebastian Lerch
}
