% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perf.R
\name{gains_table}
\alias{gains_table}
\title{Gains Table}
\usage{
gains_table(score, label, bin_num = 10, method = "freq", width_by = NULL,
  breaks_by = NULL, positive = "bad|1", ...)
}
\arguments{
\item{score}{A list of credit score for actual and expected data samples. For example, score = list(actual = scoreA, expect = scoreE).}

\item{label}{A list of label value for actual and expected data samples. For example, label = list(actual = labelA, expect = labelE).}

\item{bin_num}{Integer, the number of score bins. Defaults to 10. If it is 'max', then individual scores are used as bins.}

\item{method}{The score is binning by equal frequency or equal width. Accepted values are 'freq' and 'width'. Defaults to 'freq'.}

\item{width_by}{Number, increment of the score breaks when method is set as 'width'. If it is provided the above parameter bin_num will not be used. Defaults to NULL.}

\item{breaks_by}{The name of data set to create breakpoints. Defaults to the first data set. Or numeric values to set breakpoints manually.}

\item{positive}{Value of positive class, Defaults to "bad|1".}

\item{...}{Additional parameters.}
}
\value{
A data frame
}
\description{
\code{gains_table} creates a data frame including distribution of total, negative, positive, positive rate and rejected rate by score bins. The gains table is used in conjunction with financial and operational considerations to make cutoff decisions.
}
\examples{
\donttest{
# load germancredit data
data("germancredit")
# filter variable via missing rate, iv, identical value rate
dtvf = var_filter(germancredit, "creditability")

# breaking dt into train and test
dt_list = split_df(dtvf, "creditability")
label_list = lapply(dt_list, function(x) x$creditability)

# binning
bins = woebin(dt_list$train, "creditability")
# scorecard
card = scorecard2(bins, dt = dt_list$train, y = 'creditability')

# credit score
score_list = lapply(dt_list, function(x) scorecard_ply(x, card))


###### gains_table examples ######
# Example I, input score and label can be a vector or a list
g1 = gains_table(score = unlist(score_list), label = unlist(label_list))
g2 = gains_table(score = score_list, label = label_list)

# Example II, specify the bins number and type
g3 = gains_table(score = unlist(score_list), label = unlist(label_list), bin_num = 20)
g4 = gains_table(score = unlist(score_list), label = unlist(label_list), method = 'width')
}

}
\seealso{
\code{\link{perf_eva}} \code{\link{perf_psi}}
}
