% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{plotCloneSummary}
\alias{plotCloneSummary}
\title{Plot clonal clustering summary}
\usage{
plotCloneSummary(
  data,
  xmin = NULL,
  xmax = NULL,
  breaks = NULL,
  binwidth = NULL,
  title = NULL,
  size = 0.75,
  silent = FALSE,
  ...
)
}
\arguments{
\item{data}{\link{ScoperClones} object output by the \link{spectralClones}, 
\link{identicalClones} or \link{hierarchicalClones}.}

\item{xmin}{minimum limit for plotting the x-axis. If \code{NULL} the limit will 
be set automatically.}

\item{xmax}{maximum limit for plotting the x-axis. If \code{NULL} the limit will 
be set automatically.}

\item{breaks}{number of breaks to show on the x-axis. If \code{NULL} the breaks will 
be set automatically.}

\item{binwidth}{binwidth for the histogram. If \code{NULL} the binwidth 
will be set automatically.}

\item{title}{string defining the plot title.}

\item{size}{numeric value for lines in the plot.}

\item{silent}{if \code{TRUE} do not draw the plot and just return the ggplot2 
object; if \code{FALSE} draw the plot.}

\item{...}{additional arguments to pass to ggplot2::theme.}
}
\value{
A ggplot object defining the plot.
}
\description{
\code{plotCloneSummary} plots the results in a \code{ScoperClones} object returned 
by \code{spectralClones}, \code{identicalClones} or \code{hierarchicalClones}.  
Includes the minimum inter (between) and maximum intra (within) clonal distances 
and the calculated efective threshold.
}
\examples{
# Find clones
results <- hierarchicalClones(ExampleDb, threshold=0.15)

# Plot clonal summaries
plot(results, binwidth=0.02)

}
\seealso{
See \link{ScoperClones} for the the input object definition.  
          See \link{spectralClones}, \link{identicalClones} and \link{hierarchicalClones} 
          for generating the input object.
}
