% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tests.R
\name{tukeyTest}
\alias{tukeyTest}
\title{Tukey test}
\usage{
tukeyTest(data, alpha = 0.05)
}
\arguments{
\item{data}{Matrix or data frame where each algorithm is in a column}

\item{alpha}{Significance level}
}
\value{
A list with class "htest" containing the following components: \code{statistic}, the value of the statistic used in the test; \code{method}, a character string indicating what type of test was performed; \code{data.name}, a character string giving the name of the data and \code{diff.matirx}, a matrix with all the pairwise absolute difference of average values.
}
\description{
This function performs the Tukey test
}
\details{
The test has been implemented according to Test 28 in Kanji (2006).
}
\examples{
data(data_gh_2008)
res <- tukeyTest(data.gh.2008, alpha=0.1)
res
res$diff.matrix
}
\references{
Kanji, G. K. (2006) \emph{100 Statistical Tests}. SAGE Publications Ltd, 3rd edition.
}

