% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scdensity.R
\name{plot.scdensity}
\alias{plot.scdensity}
\title{Plot method for class \code{scdensity}.}
\usage{
\method{plot}{scdensity}(x, detail = 4, main = c("Density Estimate",
  "Q-Q Plot"), xlab = c(x$data.name, "Constrained KDE Quantiles"),
  ylab = c("Density", "Sample Quantiles"), type = c("l", "l", "p"),
  lty = c(1, 2, 0), pch = c(-1, -1, 1), col = c("black", gray(0.4),
  "black"), lwd = c(2, 1, 0), zero.line = TRUE, ...)
}
\arguments{
\item{x}{An object of S3 class \code{scdensity}.}

\item{detail}{An integer from 1 to 4, indicating the level of information to include in
the plot.  1: plot only the constrained estimate.  2: draw both the constrained and
unconstrained estimates on the same plot.  3: add a rug showing the data points.
4: additionally plot a Q-Q plot of the observed data versus the constrained estimate in a
second panel (for qualitative assessment of goodness-of-fit).}

\item{main}{A string passed on to the \code{main} argument of the plot command. If
\code{detail == 4}, pass a vector of two strings to specify titles for both subfigures.}

\item{xlab}{A string passed on to the \code{xlab} argument of the plot command. If
\code{detail == 4}, pass a vector of two strings to specify x labels for both subfigures.}

\item{ylab}{A string passed on to the \code{ylab} argument of the plot command. If
\code{detail == 4}, pass a vector of two strings to specify y labels for both subfigures.}

\item{type}{A vector of up to 3 strings specifying the \code{type} of plot used for 1)
the constrained estimate, 2) the unconstrained estimate, and 3) the Q-Q plot.}

\item{lty}{A vector of up to length 3, specifying the \code{lty} arguments passed to the
plot commands for 1) the constrained estimate, 2) the unconstrained estimate, and 3)
the Q-Q plot. See the description of \code{lty} in \code{\link[graphics]{par}}.}

\item{pch}{A vector of up to 3 integers specifying the \code{pch} argument passed to the
plot commands for 1) the constrained estimate, 2) the unconstrained estimate, and 3)
the Q-Q plot.  See \code{\link[graphics]{points}} for the integer codes.}

\item{col}{A vector of up to 3 strings specifying the \code{col} argument passed to the
plot commands for 1) the constrained estimate, 2) the unconstrained estimate, and 3)
the Q-Q plot.}

\item{lwd}{A vector of up to length 3 specifying the \code{lwd} argument passed to the
plot commands for 1) the constrained estimate, 2) the unconstrained estimate, and 3)
the Q-Q plot.}

\item{zero.line}{A logical value indicating whether or not a horizontal line should be
drawn through zero to aid visualization.}

\item{...}{Extra parameters passed to the initial \code{plot} command for each subfigure.}
}
\description{
Creates a plot of a shape-constrained kernel density estimate.  The amount of information
in the plot is controlled by \code{detail}.
}
\examples{
# Basic usage:
x <- rlnorm(30)
scKDE <- scdensity(x)
plot(scKDE)

# Show only the constrained estimate
plot(scKDE, detail=1)

# Show the constrained and unconstrained estimates.  Change line color and width.
plot(scKDE, detail=2, col=c("red","blue"), lwd=c(3,2))

# Show the Q-Q plot, but change that plot's symbol and its size.
plot(scKDE, detail=4, pch=c(-1, -1, 3), cex=0.5)
}
