% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scclust.R
\name{scclust}
\alias{scclust}
\title{Constructor for scclust objects}
\usage{
scclust(cluster_labels, unassigned_labels = NULL, ids = NULL)
}
\arguments{
\item{cluster_labels}{a vector containing each data point's cluster label.}

\item{unassigned_labels}{labels that denote unassigned data points. If \code{NULL}, \code{NA}
values in \code{cluster_labels} are used to denote unassigned points.}

\item{ids}{IDs of the data points. Should be a vector of the same length as
\code{cluster_labels} or \code{NULL}. If \code{NULL}, the IDs are set
to \code{1:length(cluster_labels)}.}
}
\value{
Returns a \code{scclust} object with the clustering described by the
   provided labels.
}
\description{
The \code{scclust} function constructs a \code{scclust} object from existing
cluster labels.
}
\details{
\code{scclust} does not derive clusters from sets of data points; see
\code{\link{sc_clustering}} and \code{\link{hierarchical_clustering}} for
that functionality.
}
\examples{
# 10 data points in 3 clusters
my_scclust1 <- scclust(c("A", "A", "B", "C", "B",
                         "C", "C", "A", "B", "B"))

# 8 data points in 3 clusters, 2 points unassigned
my_scclust2 <- scclust(c(1, 1, 2, 3, 2,
                         NA, 3, 1, NA, 2))

# Custom labels indicating unassiged points
my_scclust3 <- scclust(c("A", "A", "B", "C", "NONE",
                         "C", "C", "NONE", "B", "B"),
                       unassigned_labels = "NONE")

# Two different labels indicating unassiged points
my_scclust4 <- scclust(c("A", "A", "B", "C", "NONE",
                         "C", "C", "0", "B", "B"),
                       unassigned_labels = c("NONE", "0"))

# Custom data point IDs
my_labels5 <- scclust(c("A", "A", "B", "C", "B",
                        "C", "C", "A", "B", "B"),
                      ids = letters[1:10])

}
