% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/style_plotSC.R
\name{style_plotSC}
\alias{style_plotSC}
\alias{style.plotSC}
\title{Create styles for single-case data plots}
\usage{
style_plotSC(style = "default", ...)

style.plotSC(...)
}
\arguments{
\item{style}{Predefined styles.}

\item{...}{Further arguments passed to the plot command.}
}
\value{
Returns a list to be provided or the style argument of the plot function.

\itemize{ 
\item\code{fill} If set, the area under the line is
filled with the given color (e.g., \code{fill = "tomato"}). Use the standard
R command colors() to get a list of all possible colours. \code{fill} is
empty by default.  
\item\code{annotations} A list of parameters defining
annotations to each data point. This adds the score of each MT to your plot.
\itemize{ 
\item\code{"pos"} Position of the annotations: 1 = below, 2 =
left, 3 = above, 4 = right.  
\item\code{"col"} Color of the annotations.
\item\code{"cex"} Size of the annotations.
\item\code{"round"} Rounds the values to the specified decimal.} 
\item\code{annotations = list(pos = 3, col =
"brown", round = 1)} adds scores rounded to one decimal above the data point
in brown color to the plot.
\item\code{"lwd"} Width of the plot line. Default is \code{lwd = 2}.
\item\code{"pch"} Point type. Default is \code{pch = 17} (triangles). Other options
are for example: 16 (filled circles) or "A" (uses the letter A).
\item\code{"main"} Main title of the plot.
\item\code{"mai"} Sets the margins of the plot.
\item\code{"bty"} Shape of the frame surrounding the inner plot
\item\code{"fill.bg"} Backgroundcolor of the plot.
\item\code{"grid"} Color of a grid.
\item\code{"text.ABlag"} Text displayed between phases.
\item\code{"cex.axis"} Size of the axis annotations
\item\code{"las"} Orientation of the axis annotations
\item\code{"col.lines"} Color of the lines
\item\code{"col.dots"} Color of the dots
\item\code{"col.seperator"} Color of the phase seperating lines
\item\code{"col.bg"} Color of the outer plot
\item\code{"col"} General color setting for the plot
\item\code{"col.text"} Color of all labels of the plot.
}
}
\description{
The \code{style_plotSC} function is used to create graphical styles for a single-case plot
}
\details{
\code{style_plotSC("")} will return a list of predefined styles.
Predefined styles can be combined \code{style_plotSC(style = c("grid2", "tiny"))} 
where settings of a latter style overwrite settings of the former.
Additional style paramters are set following the style argument and can be combined with those:
\code{style_plotSC(style = "grid2", fill = "grey50", pch = 18)}.
}
\examples{
newstyle <- style_plotSC(style = "default")
newstyle$text.ABlag <- c("START","END")
newstyle$col.dots <- ""
newstyle$annotations <- list(cex = 0.6, col = "grey10", offset = 0.4)
plot(exampleABC, style = newstyle)

}
\seealso{
\code{\link{plot.scdf}}
}
\author{
Juergen Wilbert
}
