% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rciSC.R
\name{rciSC}
\alias{rciSC}
\alias{rCi}
\title{Reliable change index}
\usage{
rciSC(data, dvar, pvar, rel = 0.8, ci = 0.95, graph = FALSE,
  phases = c(1, 2))
}
\arguments{
\item{data}{A single-case data frame. See \code{\link{scdf}} to learn about
this format.}

\item{dvar}{Character string with the name of the dependent variable.}

\item{pvar}{Character string with the name of the phase variable.}

\item{rel}{Reliability of the measure, used to compute the standard error.
Default is \code{rel = 0.8}.}

\item{ci}{Width of confidence interval as a decimal. Default is \code{ci =
0.95} applying a 95\%-confidence interval.}

\item{graph}{If set \code{TRUE}, a box plot of phase A and B scores is
displayed. \code{graph = FALSE} by default.}

\item{phases}{A vector of two characters or numbers indicating the two
phases that should be compared. E.g., \code{phases = c("A","C")} or
\code{phases = c(2,4)} for comparing the second and the fourth phase. Phases
could be combined by providing a list with two elements. E.g., \code{phases
= list(A = c(1,3), B = c(2,4))} will compare phases 1 and 3 (as A) against 2
and 4 (as B). Default is \code{phases = c("A","B")}.}
}
\value{
\item{RCI}{A list of three RCI calculations (Jacobson et al.,
Christenden et al., Hageman et al.).} \item{stand.dif}{Standardized
difference between mean phase A and B scores.} \item{conf}{A matrix
containing the lower and upper confidence interval boundaries of phases A
and B.} \item{conf.percent}{Numeric argument from function call (see
\code{ci} in \code{Arguments} section).} \item{reliability}{Numeric argument
from function call (see \code{Arguments} above).} \item{descriptives}{A
matrix containing descriptive statistics for phases A and B: n, mean, SD,
SE.} \item{N}{Number of cases.} \item{A}{A vector of phase A scores.}
\item{B}{A vector of phase B scores.}
}
\description{
\bold{CAUTION! This function is still under development and not ready for
use!} The \code{rciSC} function computes three indices of reliable change
(Wise, 2004) and corresponding descriptive statistics.
}
\examples{

## Report the RCIs of the first case from the byHeart data and include a graph
rciSC(byHeart2011[1], graph = TRUE)

}
\references{
Christensen, L., & Mendoza, J. L. (1986). A method of assessing
change in a single subject: An alteration of the RC index. \emph{Behavior
Therapy, 17}, 305-308.

Hageman, W. J. J., & Arrindell, W. A. (1993). A further refinement of the
reliable change (RC) index by improving the pre-post difference score:
Introducing RCID. \emph{Behaviour Research and Therapy, 31}, 693-700.

Jacobson, N. S., & Truax, P. (1991). Clinical Significance: A statistical
approach to defining meaningful change in psychotherapy research.
\emph{Journal of Consulting and Clinical Psychology, 59}, 12-19.

Wise, E. A. (2004). Methods for analyzing psychotherapy outcomes: A review
of clinical significance, reliable change, and recommendations for future
directions. \emph{Journal of Personality Assessment, 82}, 50 - 59.
}
\author{
Juergen Wilbert
}
