% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/longSCDF.R
\name{longSCDF}
\alias{longSCDF}
\title{Creating a long format data frame from several single-case data frames
(scdf).}
\usage{
longSCDF(data, l2 = NULL, id = "case")
}
\arguments{
\item{data}{A single-case data frame. See \code{\link{scdf}} to learn about this format.}

\item{l2}{A data frame providing additional variables at Level 2. The scdf
has to have names for all cases and the Level 2 data frame has to have a
column with corresponding case names.}

\item{id}{Variable name of the Level 2 data frame that contains the case
names.}
}
\value{
Returns one data frame with data of all single-cases structured by
the case variable.
}
\description{
The longSCDF function transposes a scdf into one long data frame.
Additionally, a data frame can be merged that includes data of the subjects.
This might be helpful to prepare data to be used with other packages than scan.
}
\examples{

## Convert the list of three single-case data frames from Grosche (2011) into one long data frame
Grosche2011
Grosche2011_long <- longSCDF(Grosche2011)
Grosche2011_long

## Combine an scdf with data for l2
Leidig2018_long <- longSCDF(Leidig2018, l2 = Leidig2018_l2)
names(Leidig2018_long)
summary(Leidig2018_long)

}
\seealso{
Other data manipulation functions: \code{\link{fillmissingSC}},
  \code{\link{outlierSC}}, \code{\link{rankSC}},
  \code{\link{scaleSC}}, \code{\link{shiftSC}},
  \code{\link{smoothSC}}, \code{\link{truncateSC}}
}
\author{
Juergen Wilbert
}
\concept{data manipulation functions}
\keyword{manip}
