\name{smooth.construct.tescx.smooth.spec}
\alias{smooth.construct.tescx.smooth.spec}

\title{Tensor product smoothing constructor for a bivariate function convex
        in the second covariate
}
\description{This is a special method function
  for creating tensor product bivariate smooths convex in the second covariate which is built by the \code{mgcv} constructor function for smooth terms, \code{smooth.construct}. 
  It is constructed from a pair of single penalty
  marginal smooths. This tensor product is specified by model terms such as \code{s(x1,x2,k=c(q1,q2),bs="tescx",m=c(2,2))}, 
  where the basis for the first marginal smooth is specified in the second element of \code{bs}.

}
\usage{
\method{smooth.construct}{tescx.smooth.spec}(object, data, knots)
}
\arguments{
  \item{object}{A smooth specification object, generated by an \code{s} term in a GAM formula.} 

  \item{data}{A data frame or list containing the values of the elements of \code{object$term},
     with names given by \code{object$term}.}
 
  \item{knots}{An optional list containing the knots corresponding to \code{object$term}. 
          If it is \code{NULL} then the knot locations are generated automatically.}
 
}
%\details{
%%  ~~ If necessary, more details than the description above ~~
%}
\value{An object of class \code{"tescx.smooth"}. In addition to the usual 
elements of a smooth class documented under \code{smooth.construct} of the \code{mgcv} library, this object contains:
\item{p.ident}{A vector of 0's and 1's for model parameter identification: 
     1's indicate parameters which will be exponentiated, 0's - otherwise.}
\item{Zc}{A matrix of identifiability constraints.}
\item{margin.class}{The class of the first unconstrained marginal smooth.}

}
\references{
Pya, N. and Wood, S.N. (2015) Shape constrained additive models. Statistics and Computing, 25(3), 543-559

}
\author{
Natalya Pya <nat.pya@gmail.com>

}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
 \code{\link{smooth.construct.temicv.smooth.spec}}
  \code{\link{smooth.construct.temicx.smooth.spec}}
  \code{\link{smooth.construct.tedecv.smooth.spec}}
  \code{\link{smooth.construct.tedecx.smooth.spec}}
  \code{\link{smooth.construct.tescv.smooth.spec}}
}
\examples{
 \dontrun{
## tensor product `tescx' example 
  ## simulating data...
   set.seed(2)
   n <- 30
   x1 <- sort(runif(n))
   x2 <- sort(runif(n))
   f1 <- matrix(0,n,n)
   for (i in 1:n) for (j in 1:n) 
       { f1[i,j] <- 2*sin(pi*x1[i]) + 2*exp(x2[j]-0.5)}
   f1 <- as.vector(t(f1))
   f <- (f1-min(f1))/(max(f1)-min(f1))
   y <- f+rnorm(length(f))*0.1
   x11 <-  matrix(0,n,n)
   x11[,1:n] <- x1
   x11 <- as.vector(t(x11))
   x22 <- rep(x2,n)
   dat <- list(x1=x11,x2=x22,y=y)
## fit model ...
   b <- scam(y~s(x1,x2,k=c(10,10),bs="tescx",m=2),
            family=gaussian(), data=dat)
## plot results ...
   par(mfrow=c(2,2),mar=c(4,4,2,2))
   plot(b,se=TRUE)
   plot(b,pers=TRUE, theta = 50, phi = 20) 
   plot(y,b$fitted.values,xlab="Simulated data",ylab="Fitted data")
   x11()
   vis.scam(b, theta=30)
 }
}

\keyword{models} \keyword{regression}%-- one or more ..
