% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCALPEL_graphics.R
\name{plotSpatial}
\alias{plotSpatial}
\title{Plot spatial components from Steps 2 or 3 of SCALPEL.}
\usage{
plotSpatial(scalpelOutput = NULL, neuronSet = "", neuronsToDisplay = NULL,
  colVec = NULL, title = "", fileName = NULL, pctTransp = 0.7,
  number = TRUE, addToPlot = FALSE, border = FALSE, zoom = FALSE,
  A = NULL, videoHeight = NULL)
}
\arguments{
\item{scalpelOutput}{An object returned by one of these SCALPEL functions:
\code{\link{scalpel}}, \code{\link{scalpelStep2}}, or \code{\link{scalpelStep3}}.}

\item{neuronSet}{Which set of neurons should be plotted:
use \code{"A"} for the dictionary elements resulting from \code{\link{scalpelStep2}} and saved as \code{scalpelOutput$A},
or use \code{"Afilter"} for the filtered dictionary elements resulting from \code{\link{scalpelStep3}} and saved as \code{scalpelOutput$Afilter}.}

\item{neuronsToDisplay}{Vector giving which neurons' spatial components to plot. The indices refer to which columns to plot
of \code{scalpelOutput$Afilter} (if \code{neuronSet="Afilter"}), or \code{scalpelOutput$A} (if \code{neuronSet="A"}). By default, all components are plotted.
Users may also specify \code{"kept"}, which will exclude all dictionary elements discarded using a previous call to \code{\link{reviewNeurons}} or \code{\link{reviewNeuronsInteractive}}.}

\item{colVec}{Vector of colors to use, which are chosen automatically if the default value of NULL is used.}

\item{title}{Label for the title.}

\item{fileName}{If provided, the plot will be saved to the specified location.}

\item{pctTransp}{The percent transparency (in [0,1]) for the colors used to plot the neurons. The default value is 0.7.}

\item{number}{Logical value indicating whether the neurons should be numbered.}

\item{addToPlot}{Logical value indicating whether these neurons should be plotted to an existing plot.}

\item{border}{Logical value indicating whether only the borders of the neurons should be plotted.}

\item{zoom}{Logical value indicating whether the plot should be zoomed in to exclude any area not containing neurons.}

\item{A}{Optional advanced user argument: A matrix containing the spatial components to plot, where the ith column of \code{A}
is a vector of 1's and 0's, indicating whether each pixel is contained in the ith spatial component. By default,
this argument is ignored and the dictionary elements saved in \code{scalpelOutput$A} or \code{scalpelOutput$Afilter} are plotted. If \code{A} is provided,
\code{scalpelOutput} will be ignored and \code{neuronsToDisplay} will refer to the columns of \code{A}.}

\item{videoHeight}{The height of the video (in pixels). This only needs to be specified if the user is plotting \code{A}.}
}
\value{
None
}
\description{
We plot the dictionary elements obtained from Step 2 of SCALPEL, or the filtered dictionary elements from Step 3 of SCALPEL.
}
\details{
When \code{neuronSet="Afilter"}, spatial components corresponding to temporal components that were zeroed out in the sparse group lasso are plotted in gray, unless \code{colVec} is specified by the user.
}
\examples{
\dontrun{
### many of the functions in this package are interconnected so the
### easiest way to learn to use the package is by working through the vignette,
### which is available at ajpete.com/software

#assumes you have run the example for the "scalpel" function

#simplest example with default parameters:
plotSpatial(scalpelOutput = scalpelOutput, neuronSet = "Afilter")

#example with optional parameters:
#plot only two of the neurons, add a title, do not number neurons,
#and draw the outlines of the neurons
plotSpatial(scalpelOutput = scalpelOutput, neuronsToDisplay = c(1,2), neuronSet = "Afilter",
           title = "First two neurons", number = FALSE, border = TRUE)
}
}
\seealso{
\code{\link{scalpelStep2}}, \code{\link{scalpelStep3}}, \code{\link{scalpel}}, \code{\link{plotResults}}
}

