% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BCR.top100CDR3Abundance.R
\name{BCR.top100CDR3Abundance}
\alias{BCR.top100CDR3Abundance}
\title{#' Get the 100 most abundant CDR3}
\usage{
BCR.top100CDR3Abundance(contigList, sampleName)
}
\arguments{
\item{contigList}{The product of TCR.ContigList().}

\item{sampleName}{The sample name of single cell sample.}
}
\value{
Multiple pictures in the form of a list.
}
\description{
#' Get the 100 most abundant CDR3
}
\examples{

project_data_dir <- "F:/R_Language/data/bcr"
sample_name <- list.dirs(project_data_dir, full.names = FALSE, recursive = FALSE)
group_name <- c("A", "A", "B", "B")
contig_list <- BCR.ContigList(project_data_dir, sample_name, group_name)

BasicPlot(BCR.top100CDR3Abundance, contig_list, sample_name)
}
