% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_tucker.R
\name{plot_loadings_annot}
\alias{plot_loadings_annot}
\title{Plot the gene by celltype loadings for a factor}
\usage{
plot_loadings_annot(
  container,
  factor_select,
  use_sig_only = FALSE,
  nonsig_to_zero = FALSE,
  annot = "none",
  pathways = NULL,
  sim_de_donor_group = NULL,
  sig_thresh = 0.05,
  display_genes = FALSE,
  gene_callouts = FALSE,
  callout_n_gene_per_ctype = 5,
  callout_ctypes = NULL,
  specific_callouts = NULL,
  le_set_callouts = NULL,
  le_set_colormap = NULL,
  le_set_num_per = 5,
  show_le_legend = FALSE,
  show_xlab = TRUE,
  show_var_explained = TRUE,
  clust_method = "median",
  h_w = NULL,
  reset_other_factor_plots = FALSE,
  draw_plot = TRUE
)
}
\arguments{
\item{container}{environment Project container that stores sub-containers
for each cell type as well as results and plots from all analyses}

\item{factor_select}{numeric The factor to plot}

\item{use_sig_only}{logical If TRUE, includes only significant genes
from jackstraw in the heatmap. If FALSE, includes all the variable genes.
(default = FALSE)}

\item{nonsig_to_zero}{logical If TRUE, makes the loadings of all nonsignificant genes 0
(default=FALSE)}

\item{annot}{character If set to "pathways" then creates an adjacent heatmap
showing which genes are in which pathways. If set to "sig_genes" then creates
an adjacent heatmap showing which genes were significant from jackstraw. If
set to "none" no adjacent heatmap is plotted. (default="none")}

\item{pathways}{character Gene sets to plot if annot is set to "pathways"
(default=NULL)}

\item{sim_de_donor_group}{numeric To plot the ground truth significant genes from a
simulation next to the heatmap, put the number of the donor group that corresponds to
the factor being plotted (default=NULL)}

\item{sig_thresh}{numeric Pvalue significance threshold to use. If use_sig_only is
TRUE the threshold is used as a cutoff for genes to include. If annot is "sig_genes"
this value is used in the gene significance colormap as a minimum threshold. (default=0.05)}

\item{display_genes}{logical If TRUE, displays the names of gene names (default=FALSE)}

\item{gene_callouts}{logical If TRUE, then adds gene callout annotations to the heatmap
(default=FALSE)}

\item{callout_n_gene_per_ctype}{numeric To use if gene_callouts is TRUE. Sets the number
of largest magnitude significant genes from each cell type to include in gene callouts.
(default=5)}

\item{callout_ctypes}{character To use if gene_callouts is TRUE. Specifies which cell types
to get gene callouts for. If NULL, then gets gene callouts for largest magnitude significant
genes for all cell types. (default=NULL)}

\item{specific_callouts}{character A vector of gene names to show callouts for (default=NULL)}

\item{le_set_callouts}{character Pass a vector of gene set names to show leading edge genes
for a select set of gene sets (default=NULL)}

\item{le_set_colormap}{character A named vector with names as gene sets and values as colors.
If NULL, then selects first n colors of Set3 color palette. (default=NULL)}

\item{le_set_num_per}{numeric The number of leading edge genes to show for each gene set (default=5)}

\item{show_le_legend}{logical Set to TRUE to show the color map legend for leading edge genes (default=FALSE)}

\item{show_xlab}{logical If TRUE, displays the xlabel 'genes' (default=TRUE)}

\item{show_var_explained}{logical If TRUE then shows an anotation with the explained variance
for each cell type (default=TRUE)}

\item{clust_method}{character The hclust method to use for clustering rows (default='median')}

\item{h_w}{numeric Vector specifying height and width (defualt=NULL)}

\item{reset_other_factor_plots}{logical Set to TRUE to set all other loadings plots to NULL.
Useful if run get_all_lds_factor_plots but then only want to show one or two plots. (default=FALSE)}

\item{draw_plot}{logical Set to TRUE to show the plot. Plot is stored regardless. (default=TRUE)}
}
\value{
The project container with a heatmap of loadings for one factor put in container$plots$all_lds_plots.
The legend for the heatmap is put in container$plots$all_legends. Use draw(<hmap obj>,annotation_legend_list = <hmap legend obj>)
to re-render the plot with legend.
}
\description{
Plot the gene by celltype loadings for a factor
}
\examples{
test_container <- plot_loadings_annot(test_container, 1, display_genes=FALSE,
show_var_explained = TRUE)
}
