% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/determine_ranks_tucker.R
\name{get_num_batch_ranks}
\alias{get_num_batch_ranks}
\title{Plot factor-batch associations for increasing number of donor factors}
\usage{
get_num_batch_ranks(
  container,
  donor_ranks_test,
  gene_ranks,
  batch_var,
  thresh = 0.5,
  tucker_type = "regular",
  rotation_type = "hybrid"
)
}
\arguments{
\item{container}{environment Project container that stores sub-containers
for each cell type as well as results and plots from all analyses}

\item{donor_ranks_test}{numeric The number of donor rank values to test}

\item{gene_ranks}{numeric The number of gene ranks to use throughout}

\item{batch_var}{character The name of the batch meta variable}

\item{thresh}{numeric The threshold r-squared cutoff for considering a
factor to be a batch factor. Can be a vector of multiple values to get plots
at varying thresholds. (default=0.5)}

\item{tucker_type}{character Set to 'regular' to run regular tucker or to 'sparse' to run tucker
with sparsity constraints (default='regular')}

\item{rotation_type}{character Set to 'hybrid' to optimize loadings via our hybrid
method (see paper for details). Set to 'ica_dsc' to perform ICA rotation
on resulting donor factor matrix. Set to 'ica_lds' to optimize loadings by the
ICA rotation. (default='hybrid')}
}
\value{
A ggpubr figure of ggplot objects showing batch-factor associations and
placed in container$plots$num_batch_factors slot
}
\description{
Plot factor-batch associations for increasing number of donor factors
}
\examples{
test_container <- get_num_batch_ranks(test_container, donor_ranks_test=c(2:4), 
gene_ranks=10, batch_var='lanes', thresh=0.5, tucker_type='regular', rotation_type='hybrid')
}
