% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Seurat_Plotting.R
\name{DimPlot_scCustom}
\alias{DimPlot_scCustom}
\title{DimPlot with modified default settings}
\usage{
DimPlot_scCustom(
  seurat_object,
  colors_use = NULL,
  pt.size = NULL,
  reduction = NULL,
  group.by = NULL,
  split.by = NULL,
  split_seurat = FALSE,
  figure_plot = FALSE,
  aspect_ratio = NULL,
  shuffle = TRUE,
  seed = 1,
  label = NULL,
  label.size = 4,
  label.color = "black",
  label.box = FALSE,
  dims = c(1, 2),
  repel = FALSE,
  raster = NULL,
  raster.dpi = c(512, 512),
  num_columns = NULL,
  ggplot_default_colors = FALSE,
  color_seed = 123,
  ...
)
}
\arguments{
\item{seurat_object}{Seurat object name.}

\item{colors_use}{color palette to use for plotting.  By default if number of levels plotted is less than
or equal to 36 it will use "polychrome" and if greater than 36 will use "varibow" with shuffle = TRUE
both from \code{DiscretePalette_scCustomize}.}

\item{pt.size}{Adjust point size for plotting.}

\item{reduction}{Dimensionality Reduction to use (if NULL then defaults to Object default).}

\item{group.by}{Name of one or more metadata columns to group (color) cells by (for example, orig.ident);
default is the current active.ident of the object.}

\item{split.by}{Feature to split plots by (i.e. "orig.ident").}

\item{split_seurat}{logical.  Whether or not to display split plots like Seurat (shared y axis) or as
individual plots in layout.  Default is FALSE.}

\item{figure_plot}{logical.  Whether to remove the axes and plot with legend on left of plot denoting
axes labels.  (Default is FALSE).  Requires \code{split_seurat = TRUE}.}

\item{aspect_ratio}{Control the aspect ratio (y:x axes ratio length).  Must be numeric value;
Default is NULL.}

\item{shuffle}{logical. Whether to randomly shuffle the order of points. This can be useful for crowded
plots if points of interest are being buried. (Default is TRUE).}

\item{seed}{Sets the seed if randomly shuffling the order of points.}

\item{label}{Whether to label the clusters.  By default if \code{group.by = NULL} label = TRUE, and
otherwise it is FALSE.}

\item{label.size}{Sets size of labels.}

\item{label.color}{Sets the color of the label text.}

\item{label.box}{Whether to put a box around the label text (geom_text vs geom_label).}

\item{dims}{Which dimensions to plot.  Defaults to c(1,2) if not specified.}

\item{repel}{Repel labels.}

\item{raster}{Convert points to raster format.  Default is NULL which will rasterize by default if
greater than 200,000 cells.}

\item{raster.dpi}{Pixel resolution for rasterized plots, passed to geom_scattermore().
Default is c(512, 512).}

\item{num_columns}{Number of columns in plot layout.  Only valid if \code{split.by != NULL}.}

\item{ggplot_default_colors}{logical.  If \code{colors_use = NULL}, Whether or not to return plot using
default ggplot2 "hue" palette instead of default "polychrome" or "varibow" palettes.}

\item{color_seed}{random seed for the "varibow" palette shuffle if \code{colors_use = NULL} and number of
groups plotted is greater than 36.  Default = 123.}

\item{...}{Extra parameters passed to \code{\link[Seurat]{DimPlot}}.}
}
\value{
A ggplot object
}
\description{
Creates DimPlot with some of the settings modified from their Seurat defaults (colors_use, shuffle, label).
}
\examples{
library(Seurat)
DimPlot_scCustom(seurat_object = pbmc_small)

}
\references{
Many of the param names and descriptions are from Seurat to facilitate ease of use as
this is simply a wrapper to alter some of the default parameters \url{https://github.com/satijalab/seurat/blob/master/R/visualization.R} (License: GPL-3).
\code{figure_plot} parameter/code modified from code by Tim Stuart via twitter: \url{https://twitter.com/timoast/status/1526237116035891200?s=20&t=foJOF81aPSjr1t7pk1cUPg}.
}
\concept{seurat_plotting}
