% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Statistics_Plotting.R
\name{CellBender_Diff_Plot}
\alias{CellBender_Diff_Plot}
\title{Plot Number of Cells/Nuclei per Sample}
\usage{
CellBender_Diff_Plot(
  feature_diff_df,
  pct_diff_threshold = 25,
  num_features = NULL,
  label = TRUE,
  num_labels = 20,
  repel = TRUE,
  custom_labels = NULL,
  plot_line = TRUE,
  plot_title = "Raw Counts vs. Cell Bender Counts",
  x_axis_label = "Raw Data Counts",
  y_axis_label = "Cell Bender Counts",
  xnudge = 0,
  ynudge = 0,
  max.overlaps = 100,
  label_color = "dodgerblue",
  fontface = "bold",
  label_size = 3.88,
  bg.color = "white",
  bg.r = 0.15,
  ...
)
}
\arguments{
\item{feature_diff_df}{name of data.frame created using \code{\link[scCustomize]{CellBender_Feature_Diff}}.}

\item{pct_diff_threshold}{threshold to use for feature plotting.  Resulting plot will only contain
features which exhibit percent change >= value.  Default is 25.}

\item{num_features}{Number of features to plot.  Will ignore \code{pct_diff_threshold} and return
plot with specified number of features.  Default is NULL.}

\item{label}{logical, whether or not to label the features that have largest percent difference
between raw and CellBender counts (Default is TRUE).}

\item{num_labels}{Number of features to label if \code{label = TRUE}, (default is 20).}

\item{repel}{logical, whether to use geom_text_repel to create a nicely-repelled labels; this is
slow when a lot of points are being plotted. If using repel, set xnudge and ynudge to 0, (Default is TRUE).}

\item{custom_labels}{A custom set of features to label instead of the features most different between
raw and CellBender counts.}

\item{plot_line}{logical, whether to plot diagonal line with slope = 1 (Default is TRUE).}

\item{plot_title}{Plot title.}

\item{x_axis_label}{Label for x axis.}

\item{y_axis_label}{Label for y axis.}

\item{xnudge}{Amount to nudge X and Y coordinates of labels by.}

\item{ynudge}{Amount to nudge X and Y coordinates of labels by.}

\item{max.overlaps}{passed to \code{\link[ggrepel]{geom_text_repel}}, exclude text labels that
overlap too many things. Defaults to 100.}

\item{label_color}{Color to use for text labels.}

\item{fontface}{font face to use for text labels (“plain”, “bold”, “italic”, “bold.italic”) (Default is "bold").}

\item{label_size}{text size for feature labels (passed to \code{\link[ggrepel]{geom_text_repel}}).}

\item{bg.color}{color to use for shadow/outline of text labels (passed to \code{\link[ggrepel]{geom_text_repel}}) (Default is white).}

\item{bg.r}{radius to use for shadow/outline of text labels (passed to \code{\link[ggrepel]{geom_text_repel}}) (Default is 0.15).}

\item{...}{Extra parameters passed to \code{\link[ggrepel]{geom_text_repel}} through
\code{\link[Seurat]{LabelPoints}}.}
}
\value{
A ggplot object
}
\description{
Plot of total cell or nuclei number per sample grouped by another meta data variable.
}
\examples{
\dontrun{
# get cell bender differences data.frame
cb_stats <- CellBender_Feature_Diff(seurat_object - obj, raw_assay = "RAW",
cell_bender_assay = "RNA")

# plot
CellBender_Diff_Plot(feature_diff_df = cb_stats, pct_diff_threshold = 25)
}

}
\concept{stats_plotting}
