% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sbpiper_pe.r
\name{plot_parameter_density}
\alias{plot_parameter_density}
\title{Plot parameter density.}
\usage{
plot_parameter_density(df, parameter, fileout, title = "", logspace = TRUE,
  scientific_notation = TRUE)
}
\arguments{
\item{df}{the data set containing the parameter estimates to plot.}

\item{parameter}{the name of the parameter to plot the density}

\item{fileout}{the output file}

\item{title}{the plot title (default: "")}

\item{logspace}{true if the parameters should be plotted in logspace (default: TRUE)}

\item{scientific_notation}{true if the axis labels should be plotted in scientific notation (default: TRUE)}
}
\description{
Plot parameter density.
}
\examples{
dir.create(file.path("pe_plots"))
data(insulin_receptor_all_fits)
colnames(insulin_receptor_all_fits)[1] <- "ObjVal"
insulin_receptor_all_fits[,2:4] <- log10(insulin_receptor_all_fits[,2:4])
fileout <- file.path("pe_plots", "dens_k1.pdf")
plot_parameter_density(df=insulin_receptor_all_fits, 
                       parameter="k1", 
                       fileout=fileout) 
}
