% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/satres.R
\name{satres}
\alias{satres}
\title{\code{satres} S3 class}
\usage{
satres(dir, out_dir = NULL, only_bands = TRUE)
}
\arguments{
\item{dir}{A string or string vector.}

\item{out_dir}{A string, output folder.}

\item{only_bands}{A boolean, include only satellite bands.}
}
\value{
A vector of strings, name of the processed files.
}
\description{
Creates a \code{satres} object from a set of raster files.
}
\details{
Given a folder name or a vector of folder names, containing satellite band
raster files, creates an object containing all rasters grouped according to
their spatial resolution.

If there are several rasters of the same area (tiles), it previously merges
them to form a single raster of the total area.

A working folder where the virtual rasters are created can be indicated as a
parameter. Additionally, we indicate whether we wish to process only the
bands (B1 to B12) or all available files.
}
\examples{

esa <- system.file("extdata", "esa", package = "satres")

sr <- satres(dir = esa,
             out_dir = tempdir())

sr <- satres(dir = esa,
             out_dir = tempdir(),
             only_bands = FALSE)

}
\seealso{
\code{\link{sat_untarzip}}

Other satellite functions: 
\code{\link{as_SpatRaster}()},
\code{\link{get_spatial_resolution}()},
\code{\link{save_by_resolution}()}
}
\concept{satellite functions}
