% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.jury.stats.r
\name{as.jury.stats}
\alias{as.jury.stats}
\title{Calculates probability a jury will find defendant guilty based on juror preferences, with standard error and confidence interval}
\usage{
as.jury.stats(
  sample_pg,
  sample_n,
  jury_n = 12,
  pstrikes = 0,
  dstrikes = 0,
  accuracy = 0.15,
  digits = 3
)
}
\arguments{
\item{sample_pg}{Proportion of jurors who favor a guilty verdict; a number between 0 and 1.}

\item{sample_n}{Size of sample used to estimate sample_pg.}

\item{jury_n}{Size of the jury (i.e. 6, 8, or 12); default value is 12.}

\item{pstrikes}{Number of peremptory strikes by prosecution; default value is 0.}

\item{dstrikes}{Number of peremptory strikes by defendant; default value is 0.}

\item{accuracy}{Accuracy of parties' peremptory strikes; a number between 0 and 1; default value is .15.}

\item{digits}{Number of digits to report after decimal places; default value is 3.}
}
\value{
Returns the probability jury finds defendant guilty.
}
\description{
Calculates probability jury finds defendant guilty based on verdicts preferences of jury pool.
             Also reports standard error and confidence interval of estimate (use as.jury.point function for estimate only).
}
\examples{
   library(sate)
   as.jury.stats(sample_pg=.50, sample_n=830)

   as.jury.stats(sample_pg=10/12, sample_n=295)
}
