% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_content.R
\name{get_makeme_types}
\alias{get_makeme_types}
\title{Get all registered options for the type-argument in the \code{makeme}-function}
\usage{
get_makeme_types()
}
\value{
Character vector
}
\description{
The \code{\link[=makeme]{makeme()}}-function take for the argument \code{type}
one of several strings to indicate content type and output type.
This function collects all registered alternatives. Extensions are possible,
see further below.

Built-in types:

Whereas the names of the types can be arbitrary, a pattern is pursued in the
built-in types.
Prefix indicates what dependent data type it is intended for
\describe{
\item{"cat"}{Categorical (ordinal and nominal) data.}
\item{"chr"}{Open ended responses and other character data.}
\item{"int"}{Integer and numeric data.}
}

Suffix indicates output
\describe{
\item{"html"}{Interactive html, usually what you want for Quarto, as Quarto can usually convert to other formats when needed}
\item{"docx"}{However, Quarto's and Pandoc's docx-support is currently still limited, for instance as vector graphics are converted to raster graphics for docx output. Hence, \code{saros} offers some types that outputs into MS Chart vector graphics. Note that this is experimental and not actively developed.}
\item{"pdf"}{This is basically just a shortcut for "html" with \code{interactive=FALSE}}
}
}
\section{Further details about some of the built-in types:}{
\describe{
\item{"cat_plot_"}{A Likert style plot for groups of categorical variables sharing the same categories.}
\item{"cat_table_"}{A Likert style table.}
\item{"chr_table_"}{A single-column table listing unique open ended responses.}
\item{"sigtest_table_"}{See below}
}

sigtest_table_\*: Make Table with All Combinations of
Univariate/Bivariate Significance Tests Based on Variable Types

Although there are hundreds of significance tests for associations between
two variables, depending upon the distributions, variables types and
assumptions, most fall into a smaller set of popular tests. This function
runs for all combinations of dependent and independent variables in data,
with a suitable test (but not the only possible) for the combination. Also
supports univariate tests, where the assumptions are that of a mean of zero
for continuous variables or all equal proportions for binary/categorical.

This function does not allow any adjustments - use the original underlying
functions for that (chisq.test, t.test, etc.)
}

\section{Expanding with custom types}{
\code{\link[=makeme]{makeme()}} calls the generic \code{\link[=make_content]{make_content()}},
which uses the S3-method system to dispatch to the relevant method (i.e.,
\code{paste0("make_content.", type)}). makeme forwards all its arguments to make_content,
with the following exceptions:
\enumerate{
\item dep and indep are converted from \code{\link[dplyr:dplyr_tidy_select]{dplyr::dplyr_tidy_select()}}-syntax to simple character vectors, for simplifying building your own functions.
\item data_summary is attached, which contains many useful pieces of info for many (categorical) displays.
}
}

\examples{
get_makeme_types()
}
