% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draft_report.R
\name{draft_report}
\alias{draft_report}
\title{Automatically Draft a Quarto Report}
\usage{
draft_report(
  data,
  chapter_structure,
  ...,
  path = tempdir(),
  title = "Report",
  authors = NULL,
  authors_col = "author",
  chapter_yaml_file = NULL,
  chapter_qmd_start_section_filepath = NULL,
  chapter_qmd_end_section_filepath = NULL,
  index_filename = "index",
  index_yaml_file = NULL,
  index_qmd_start_section_filepath = NULL,
  index_qmd_end_section_filepath = NULL,
  report_filename = "0_report",
  report_yaml_file = NULL,
  report_qmd_start_section_filepath = NULL,
  report_qmd_end_section_filepath = NULL,
  ignore_heading_for_group = c(".template_name", ".variable_type_dep",
    ".variable_type_indep", ".variable_group_dep", "chapter"),
  replace_heading_for_group = c(.variable_label_suffix_dep = ".variable_name_dep",
    .variable_label_suffix_indep = ".variable_name_indep"),
  prefix_heading_for_group = NULL,
  suffix_heading_for_group = NULL,
  require_common_categories = TRUE,
  combined_report = TRUE,
  attach_chapter_dataset = TRUE,
  auxiliary_variables = NULL,
  serialized_format = c("rds", "qs"),
  max_path_warning_threshold = 260,
  log_file = NULL
)
}
\arguments{
\item{data}{\emph{Survey data}

\verb{obj:<data.frame>|obj:<tbl_df>|obj:<srvyr>} // Required

A data frame (or a srvyr-object) with the columns specified in the
chapter_structure 'dep', etc columns.}

\item{chapter_structure}{\emph{What goes into each chapter and sub-chapter}

\verb{obj:<data.frame>|obj:<tbl_df>} // Required

Data frame (or tibble, possibly grouped). One row per chapter. Should
contain the columns 'chapter' and 'dep', Optionally 'indep' (independent
variables) and other informative columns as needed.}

\item{...}{\emph{Dynamic dots}

<\href{https://rlang.r-lib.org/reference/dyn-dots.html}{\code{dynamic-dots}}>

Arguments forwarded to the corresponding functions that create the elements.}

\item{path}{\emph{Output path}

\verb{scalar<character>} // \emph{default:} \code{tempdir()} (\code{optional})

Path to save all output. Defaults to a temporary directory.}

\item{title}{\emph{Title of report}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

Added automatically to YAML-header of index.qmd and report.qmd-files.}

\item{authors}{\emph{Authors of entire report}

\verb{vector<character>} // \emph{default:} \code{NULL} (\code{optional})

If NULL, infers from \code{chapter_structure[[authors_col]]}, and collates for entire report.
If multiple authors per chapter, separate with semicolon. Ensure consistency.}

\item{authors_col}{\emph{Column name for author}

\verb{scalar<character>} // \emph{default:} \code{"author"} (\code{optional})

Only used if it exists. Multiple authors are separated by semicolon (and optionally with a subsequent space).}

\item{chapter_yaml_file}{\emph{Path to YAML-file to insert into each chapter qmd-file}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

Path to file used to insert header YAML, in each chapter.}

\item{chapter_qmd_start_section_filepath, chapter_qmd_end_section_filepath, index_qmd_start_section_filepath, index_qmd_end_section_filepath, report_qmd_start_section_filepath, report_qmd_end_section_filepath, }{\emph{Path to qmd-bit for start/end of each qmd}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

Path to qmd-snippet placed before/after body of all chapter/index/report qmd-files.}

\item{index_filename}{\emph{Index filename}

\verb{scalar<character>} // \emph{default:} \code{"index.qmd"} (\code{optional})

The name of the main index Quarto file used as landing
page for each report. Will link to a PDF (report.qmd) which collects all chapters.}

\item{index_yaml_file, report_yaml_file}{\emph{Path to YAML-file to insert into index.qmd and 0_report.qmd respectively}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

Path to file used to insert header YAML, in index and report files.}

\item{report_filename}{\emph{Report filename}

\verb{scalar<character>} // \emph{default:} \code{"0_report.qmd"} (\code{optional})

The name of the main report QMD-file used when compiling a complete report
collecting all chapters in its folder (except itself).
If provided, will be linked to in the index.
If NULL, will generate a filename based on the report title, prefixed with "0_".
To turn off, set \code{pdf=FALSE}.}

\item{ignore_heading_for_group}{\emph{Ignore heading for group}

\verb{vector<character>} // \emph{default:} \code{NULL} (\code{optional})

Type of refined chapter_structure data for which to suppress the heading
in the report output. Typically variable_name_dep, variable_name_indep, etc.}

\item{replace_heading_for_group}{\emph{Replacing heading for group}

\verb{named vector<character>} // \emph{default:} \code{c(".variable_label_suffix_dep" = ".variable_name_dep")}

Occasionally, one needs to replace the heading with another piece of information
in the refined chapter_structure. For instance, one may want to organize output
by variable_name_indep, but to display the variable_label_indep instead. Use
the name for the replacement and the value for the original.}

\item{prefix_heading_for_group, suffix_heading_for_group}{\emph{Prefix and suffix headings}

\verb{vector<named character>} // \emph{default:} \code{NULL} (\code{optional})

Names are heading_groups, values are the prefixes and suffixes. Note
that prefixes should end with a \verb{\\n} as headings must begin on a new line.}

\item{require_common_categories}{\emph{Check common categories}

\verb{scalar<logical>} // \emph{default:} \code{NULL} (\code{optional})

Whether to check if all items share common categories.}

\item{combined_report}{\emph{Create a combined report?}

\verb{scalar<logical>} // \emph{default:} \code{FALSE} (\code{optional})

Whether to create a qmd file that merges all chapters into
a combined report.}

\item{attach_chapter_dataset}{\emph{Toggle inclusion of chapter-specific datasets in qmd-files}

\verb{scalar<logical>} // \emph{default:} \code{FALSE}

Whether to save in each chapter folder an 'Rds'-file with the
chapter-specific dataset, and load it at the top of each QMD-file.}

\item{auxiliary_variables}{\emph{Auxiliary variables to be included in datasets}

\verb{vector<character>} // \emph{default:} \code{NULL} (\code{optional})

Column names in \code{data} that should always be included in datasets for
chapter qmd-files, if \code{attach_chapter_dataset=TRUE}. Not publicly available.}

\item{serialized_format}{\emph{Serialized format}

\verb{scalar<string>} // \emph{default:} \code{"rds"}

Format for serialized data when storing chapter dataset.
One of \code{"rds"} (default), \code{"qs"} or \code{"fst"}.
The latter two requires the respective packages to be installed.
\code{"qs"} is usually the fastest and most space efficient, but sets package
dependencies on the report project.}

\item{max_path_warning_threshold}{\emph{Maximum number of characters in paths warning}

\verb{scalar<integer>} // \emph{default:} \code{260} (\code{optional})

Microsoft has set an absolute limit of 260 characters for its Sharepoint/OneDrive
file paths. This will mean that files with cache (hash suffixes are added) will
quickly breach this limit. When set, a warning will be returned if files are found
to be longer than this threshold. Also note that spaces count as three characters
due to its URL-conversion: \%20. To avoid test, set to Inf}

\item{log_file}{\emph{Path to log file}

\verb{scalar<string>} // \emph{default:} \code{"_log.txt"} (\code{optional})

Path to log file. Set to NULL to disable logging.}
}
\value{
The \code{path}-argument.
}
\description{
The \code{draft_report()} function takes a raw dataset (\code{data}-argument) and the
output from the \code{refine_chapter_overview()}-function as the
\code{chapter_structure}-argument and outputs a set of pre-populated qmd-files in the
specified \code{path}-folder. You can edit, render, and
ultimately publish these as usual with Quarto features in RStudio. See also
\code{{saros.post}}-package for post-processing tools.
}
\details{
Note that saros treats data as they are stored: numeric,
integer, factor, ordinal, character, and datetime. Currently, only
factor/ordinal and character are implemented.
}
\examples{
\donttest{
ex_survey_ch_structure <-
  refine_chapter_overview(
    chapter_overview = ex_survey_ch_overview,
    data = ex_survey
  )
index_filepath <-
  draft_report(
    chapter_structure = ex_survey_ch_structure,
    data = ex_survey,
    path = tempdir()
  )
}
}
