% Generated by roxygen2 (4.0.2): do not edit by hand
\name{calculatePPure}
\alias{calculatePPure}
\title{Compute P_pure}
\usage{
calculatePPure(geneData, survivalTimes, followup)
}
\arguments{
\item{geneData}{An \emph{nxp} matrix consisting of \emph{n} patients
and \emph{p} genes in the candidate prognostic geneset.}

\item{survivalTimes}{A vector of survival times. The length must equal
the number of rows \emph{n} in \code{geneData}.}

\item{followup}{A vector of 0 or 1 values, indicating whether the patient was
lost to followup (0) or not (1). The length must equal the number of rows
(i.e. patients) in \code{geneData}.}
}
\value{
A list with the following elements:
\item{p_pure}{A log-rank p-value indicating the probability that the two groups
    show no survival difference.}
\item{cluster}{Vector of assigned cluster (1 or 2) for each patient using the
    supplied candidate prognostic geneset.}
}
\description{
This function stratifies patients into two groups via k-means
clustering (k=2) on an \emph{nxp} matrix consisting of \emph{n} patients
and \emph{p} genes in the candidate prognostic set. It is normally called
by \code{\link{saps}}.
}
\examples{
# 25 patients, none lost to followup
followup <- rep(1, 25)

# first 5 patients have good survival (in days)
time <- c(25, 27, 24, 21, 26, sample(1:3, 20, TRUE))*365

# create data for 100 genes, 25 patients
dat <- matrix(rnorm(25*100), nrow=25, ncol=100)
colnames(dat) <- as.character(1:100)

# create random genesets of 5 genes
set1 <- sample(colnames(dat), 5)

# get gene data for set1
set1_data <- dat[, set1]

# shouldn't achieve significance
p_pure <- calculatePPure(set1_data, time, followup)
p_pure$p_pure

# alter expression data for first 5 patients for set1
dat[1:5, set1] <- dat[1:5, set1]+10

set1_data <- dat[, set1]

# now p_pure should be significant
p_pure <- calculatePPure(set1_data, time, followup)
p_pure$p_pure
}
\references{
Beck AH, Knoblauch NW, Hefti MM, Kaplan J, Schnitt SJ, et al.
(2013) Significance Analysis of Prognostic Signatures. PLoS Comput Biol 9(1):
e1002875.doi:10.1371/journal.pcbi.1002875
}
\seealso{
\code{\link{saps}}
}

