% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{.period_to_minutes}
\alias{.period_to_minutes}
\title{transform period to minutes}
\usage{
.period_to_minutes(period, timestamp, timestep, ...)
}
\arguments{
\item{period}{character indicating the period to summarise or a custom
function name (without quotes).}

\item{timestamp}{timestamp vector obtained from data}

\item{timestep}{numeric with the timestep in minutes, obtained from metadata}

\item{...}{extra arguments for period if it is a function}
}
\value{
An integer with the period value in minutes
}
\description{
helper for data_coverage
}
\details{
This function converts the period supplied into minutes to use it in the
coverage calculation.
}
\examples{

# daily period, expected 1440 minutes
sapfluxnetr:::.period_to_minutes('1 day')

# Using a custom function, we need timestamp and timestep
sapfluxnetr:::.period_to_minutes(
  lubridate::as_date, get_timestamp(ARG_TRE), 30
)
}
\keyword{internal}
