% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/santaR_plot.R
\name{santaR_plot}
\alias{santaR_plot}
\title{Plot a SANTAObj}
\usage{
santaR_plot(
  SANTAObj,
  title = "",
  legend = TRUE,
  showIndPoint = TRUE,
  showIndCurve = TRUE,
  showGroupMeanCurve = TRUE,
  showTotalMeanCurve = FALSE,
  showConfBand = TRUE,
  colorVect = NA,
  sampling = 250,
  xlab = "x",
  ylab = "y",
  shortInd = FALSE
)
}
\arguments{
\item{SANTAObj}{A fitted \emph{SANTAObj} as generated by \code{\link{santaR_fit}}.}

\item{title}{(str) A plot title. The default title is empty.}

\item{legend}{(bool) If TRUE a legend panel is added to the right. Default is TRUE. \emph{Note: the legend cannot be generated if only the Confidence Bands or the Total Mean Curve are plotted.}}

\item{showIndPoint}{(bool) If TRUE plot each input measurements (in group color). Default is TRUE.}

\item{showIndCurve}{(bool) If TRUE plot each individual's curve (in group color). Default is TRUE.}

\item{showGroupMeanCurve}{(bool) If TRUE plot the mean curve for each group (in group color). Default is TRUE.}

\item{showTotalMeanCurve}{(bool) If TRUE plot the mean curve across all measurements and groups (in grey). Default is FALSE.}

\item{showConfBand}{If TRUE plot the confidence bands calculated with \code{\link{santaR_CBand}}.}

\item{colorVect}{Vector of \code{ggplot2} colors. The number of colors must match the number of groups \emph{(ex:\code{colorVect=c("deepskyblue","red")})}.}

\item{sampling}{(int) Number of data points to use when plotting each spline (sub-sampling). Default is 250.}

\item{xlab}{(str) x-axis label. Default is 'x'.}

\item{ylab}{(str) y-axis label. Default is 'y'.}

\item{shortInd}{if TRUE individual trajectories are only plotted on the range on which they are defined. Default is FALSE.}
}
\value{
A \code{ggplot2} \emph{plotObject}.
}
\description{
Plot a \emph{SANTAObj} generated by \code{\link{santaR_fit}}. Returns a \code{ggplot2} \emph{plotObject} that can be further modified using \code{ggplot2} grammar.
}
\examples{
## 56 measurements, 8 subjects, 7 unique time-points
Yi          <- acuteInflammation$data$var_3
ind         <- acuteInflammation$meta$ind
time        <- acuteInflammation$meta$time
group       <- acuteInflammation$meta$group
grouping    <- get_grouping(ind, group)
inputMatrix <- get_ind_time_matrix(Yi, ind, time)
SANTAObj    <- santaR_fit(inputMatrix, df=5, grouping=grouping, verbose=TRUE)
SANTAObj    <- santaR_CBand(SANTAObj, nBoot=100)
p           <- santaR_plot(SANTAObj, title='Example')
print(p)

}
\seealso{
Other Analysis: 
\code{\link{get_grouping}()},
\code{\link{get_ind_time_matrix}()},
\code{\link{santaR_CBand}()},
\code{\link{santaR_auto_fit}()},
\code{\link{santaR_auto_summary}()},
\code{\link{santaR_fit}()},
\code{\link{santaR_pvalue_dist}()},
\code{\link{santaR_pvalue_fit}()},
\code{\link{santaR_start_GUI}()}

Other AutoProcess: 
\code{\link{santaR_auto_fit}()},
\code{\link{santaR_auto_summary}()},
\code{\link{santaR_start_GUI}()}
}
\concept{Analysis}
\concept{AutoProcess}
