% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df_search.R
\name{get_eigen_DF}
\alias{get_eigen_DF}
\title{Compute the optimal df and weighted-df using 5 spline fitting metric}
\usage{
get_eigen_DF(eigen)
}
\arguments{
\item{eigen}{A list of eigenSpline parameters as generated by \code{\link{get_eigen_spline}}, containing \code{eigen$matrix}, \code{eigen$variance}, \code{eigen$model} and \code{eigen$countTP}.}
}
\value{
A list: \code{answer$df} a vector of optimum \emph{df} by CV, GCV, AIC, BIC, AICc. \code{answer$wdf} a vector of weighted optimum \emph{df} by CV, GCV, AIC, BIC, AICc.
}
\description{
Compute the optimal degree of freedom (\emph{df}) and weighted degree of freedom (\emph{wdf}) using 5 fitting metrics (\emph{\strong{CV}: Cross-Validation, \strong{GCV}: Generalised Cross-Validation, \strong{AIC}: Akaike Information Criterion, \strong{BIC}: Bayesian Information Criterion, \strong{AICc}: Akaike Information Criterion Corrected for small sample size}) over all eigenSplines generated by \code{\link{get_eigen_spline}}.
The degree of freedom (\emph{df}) is obtained by averaging the optimal \emph{df} across each eigenSpline.
The weighted degree of freedom (\emph{wdf}) is obtained by weighting the optimal \emph{df} in each eigenSpline by the percentage of variance explained by each eigenSpline, before summing the optimal \emph{df}s (variance sums to 100\%).
}
\examples{
## 8 subjects, 8 time-points, 3 variables
inputData <- acuteInflammation$data[,1:3]
ind       <- acuteInflammation$meta$ind
time      <- acuteInflammation$meta$time
eigen     <- get_eigen_spline(inputData, ind, time, nPC=NA, scaling="scaling_UV",
                              method="nipals", verbose=TRUE, centering=TRUE, ncores=0)
# nipals calculated PCA
# Importance of component(s):
#                  PC1    PC2     PC3      PC4    PC5      PC6
# R2            0.8924 0.0848 0.01055 0.006084 0.0038 0.002362
# Cumulative R2 0.8924 0.9772 0.98775 0.993838 0.9976 1.000000
get_eigen_DF(eigen)
# $df
#       CV      GCV      AIC      BIC     AICc 
# 3.362581 4.255487 3.031260 2.919159 2.172547 
# $wdf
#       CV      GCV      AIC      BIC     AICc 
# 2.293130 2.085212 6.675608 6.671545 4.467724 

}
\seealso{
Graphical implementation with \code{\link{santaR_start_GUI}}

Other DFsearch: 
\code{\link{get_eigen_DFoverlay_list}()},
\code{\link{get_eigen_spline}()},
\code{\link{get_param_evolution}()},
\code{\link{plot_nbTP_histogram}()},
\code{\link{plot_param_evolution}()}
}
\concept{DFsearch}
