% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.data.txt.r
\name{load.data.txt}
\alias{load.data.txt}
\title{Load text files into data frames}
\usage{
load.data.txt(sampling_ssh.file,
       reporting_ssh.file)
}
\arguments{
\item{sampling_ssh.file}{Path to the file linking sampling and SSH layers. Each row denotes a sampling unit. At least two columns need to be included in this file: value of the sampling attribute and the stratum each sampling unit falling into.}

\item{reporting_ssh.file}{Path to the file linking reporting and SSH layers. Each row denotes a reporting unit. The weights of each stratum should be specified in the columns.}
}
\value{
A list of data frames.
}
\description{
Convert text files into a list of data frames.
}
\examples{
bc.sampling_ssh.name <- system.file("extdata", "bc_sampling_ssh.csv",
                                    package="sandwichr")
bc.reporting_ssh.name <- system.file("extdata", "bc_reporting_ssh.csv",
                                     package="sandwichr")

bc.data <- load.data.txt(sampling_ssh.file=bc.sampling_ssh.name,
                         reporting_ssh.file=bc.reporting_ssh.name)

}
