test_that("full example test", {
  testthat::skip_on_cran()
  local_edition(3)

  ## load example dataset (this type of loading is 
  ## needed otherwise testthat produces an error)
  data(sample, envir = environment())
  input <- sample

  ## simple run
  aliquot <- expect_type(prepare_Subsample(
    sample = input, 
    number = 10), "list")
  
  ### make sure the attributes are correct
  expect_true(attr(aliquot, "package") == "sandbox")
  
  ## crash function - too many arguments
  expect_error(prepare_Subsample(
    sample = input,
    number = 10, 
    volume = 20), 
    "\\[prepare_Subsample\\(\\)\\] Only one criterion for subsampling is allowed!")
  
  ## crash because of wrong input
  test <- numeric(1)
  attr(test,"package") <- "sandbox"

  expect_error(prepare_Subsample(
    sample = test, 
    number = 10), 
    "\\[prepare_Subsample\\(\\)\\] the input for sample is not of type data.frame!")
  
  expect_error(prepare_Subsample(
    sample = numeric(), 
    number = 10), 
    "\\[prepare_Subsample\\(\\)\\] the input for sample is not an object created by 'sandbox'!")
  
})
  