% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ParamPWR.R
\docType{class}
\name{ParamPWR-class}
\alias{ParamPWR-class}
\alias{ParamPWR}
\title{A Reference Class which contains the parameters of a PWR model.}
\description{
ParamPWR contains all the parameters of a PWR model. The parameters are
calculated by the initialization Method and then updated by the Method
dynamic programming (here dynamic programming)
}
\section{Fields}{

\describe{
\item{\code{X}}{Numeric vector of length \emph{m} representing the covariates/inputs
\eqn{x_{1},\dots,x_{m}}.}

\item{\code{Y}}{Numeric vector of length \emph{m} representing the observed
response/output \eqn{y_{1},\dots,y_{m}}.}

\item{\code{m}}{Numeric. Length of the response/output vector \code{Y}.}

\item{\code{K}}{The number of regimes (PWR components).}

\item{\code{p}}{The order of the polynomial regression. \code{p} is fixed to 3 by
default.}

\item{\code{gamma}}{Set of transition points. \code{gamma} is a column matrix of size
\eqn{(K + 1, 1)}.}

\item{\code{beta}}{Parameters of the polynomial regressions. \code{beta} is a matrix of
dimension \eqn{(p + 1, K)}, with \code{p} the order of the polynomial
regression. \code{p} is fixed to 3 by default.}

\item{\code{sigma2}}{The variances for the \code{K} regimes. \code{sigma2} is a matrix of size
\eqn{(K, 1)}.}

\item{\code{phi}}{A list giving the regression design matrices for the polynomial
and the logistic regressions.}
}}

\section{Methods}{

\describe{
\item{\code{computeDynamicProgram(C1, K)}}{Method which implements the dynamic programming based on the cost matrix
\code{C1} and the number of regimes/segments \code{K}.}

\item{\code{computeParam()}}{Method which estimates the parameters \code{beta} and \code{sigma2}
knowing the transition points \code{gamma}.}
}}

