% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_functions.R
\name{calc_levy}
\alias{calc_levy}
\title{Levy Flights Calculator}
\usage{
calc_levy(chain, plot = FALSE)
}
\arguments{
\item{chain}{Matrix of n x d dimensions, n = iterations, d = dimensions.}

\item{plot}{Boolean. plot Boolean. Whether to also plot the distance-frequency relationship.}
}
\value{
If plot is true, it returns a simple plot with the log absolute difference in estimates and their frequency, as well as an estimate for the \eqn{\mu} parameter. If false it returns a list with what's required to make the plot.
}
\description{
This function analyses if the length of the jumps the sampler is making (\eqn{l}) belongs to a Levy probability density distribution, \eqn{P(l) \approx l^{-\mu}}.
}
\details{
Values of \eqn{\mu \approx 2} have been used to describe foraging in animals, and produce the most effective foraging \insertCite{viswanathan1999OptimizingSuccessRandom}{samplr}. See \insertCite{zhu2018MentalSamplingMultimodal;textual}{samplr} for a comparison of Levy Flight and PSD measures for different samplers in multimodal representations.
}
\examples{
set.seed(1)
chain1 <- sampler_mh(1, "norm", c(0,1), diag(1))
calc_levy(chain1[[1]], plot=TRUE)
}
\references{
\insertAllCited{}
}
