% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bulk-operation.R
\name{sf_end_job_bulk}
\alias{sf_end_job_bulk}
\title{End Bulk API Job}
\usage{
sf_end_job_bulk(
  job_id,
  end_type = c("Closed", "UploadComplete", "Aborted"),
  api_type = c("Bulk 1.0", "Bulk 2.0"),
  verbose = FALSE
)
}
\arguments{
\item{job_id}{\code{character}; the Salesforce Id assigned to a submitted job as
returned by \link{sf_create_job_bulk}. It will start with \code{"750"}.}

\item{end_type}{\code{character}; taking a value of "Closed" or "Aborted" indicating
how the bulk job should be ended}

\item{api_type}{\code{character}; one of \code{"REST"}, \code{"SOAP"},
\code{"Bulk 1.0"}, or \code{"Bulk 2.0"} indicating which API to use when
making the request.}

\item{verbose}{\code{logical}; an indicator of whether to print additional
detail for each API call, which is useful for debugging. More specifically, when
set to \code{TRUE} the URL, header, and body will be printed for each request,
along with additional diagnostic information where available.}
}
\value{
\code{logical}; returns \code{TRUE} if the job was able to be ended;
otherwise, an error message is printed
}
\description{
End Bulk API Job
}
\note{
This function is meant to be used internally. Only use when debugging.
}
\keyword{internal}
