% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-org.R
\name{sf_get_deleted}
\alias{sf_get_deleted}
\title{Get Deleted Records from a Timeframe}
\usage{
sf_get_deleted(object_name, start, end, verbose = FALSE)
}
\arguments{
\item{object_name}{character; the name of one Salesforce objects that the 
function is operating against (e.g. "Account", "Contact", "CustomObject__c")}

\item{start}{\code{date} or \code{datetime}; starting datetime of the timespan 
for which to retrieve the data.}

\item{end}{\code{date} or \code{datetime}; ending datetime of the timespan for
which to retrieve the data.}

\item{verbose}{logical; do you want informative messages?}
}
\description{
Retrieves the list of individual records that have been deleted within the given 
timespan for the specified object.
}
\note{
This API ignores the seconds portion of the supplied datetime values.
}
\examples{
\dontrun{
# get all deleted Contact records from midnight until now
deleted_recs <- sf_get_deleted("Contact", Sys.Date(), Sys.time())
}
}
