% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saeczi.R
\name{saeczi}
\alias{saeczi}
\title{Fit a zero-inflation estimator to a dataset}
\usage{
saeczi(
  samp_dat,
  pop_dat,
  lin_formula,
  log_formula = lin_formula,
  domain_level,
  B = 100L,
  mse_est = FALSE,
  estimand = "means",
  parallel = FALSE
)
}
\arguments{
\item{samp_dat}{A dataframe with domains, predictor variables, and the response variable of a sample}

\item{pop_dat}{A dataframe with domains and predictor variables of a population}

\item{lin_formula}{model formula for the linear regression model}

\item{log_formula}{model formula for the logistic regression model}

\item{domain_level}{A string of the column name in the dataframes that reflect the domain level}

\item{B}{An integer of the number of reps desired for the bootstrap}

\item{mse_est}{A boolean that specifies if the user}

\item{estimand}{A string specifying whether the estimates should be 'totals' or 'means'.}

\item{parallel}{Compute MSE estimation in parallel}
}
\value{
An object of class `zi_mod` with defined `print()` and `summary()` methods.
The object is structured like a list and contains the following elements:

* call: The original function call

* res: A data.frame containing the estimates and mse estimates

* lin_mod: The modeling object used to fit the original linear model

* log_mod: The modeling object used to fit the original logistic model
}
\description{
Calculate the domain predictions using the zero-inflation estimator, and outputs
those domain-level predictions, in the form of a dataframe. It contains
the estimates for each domain, as well as the mean squared error estimates should
the user choose. The output of the function is a list, with the first item being
said dataframe, and the second being the R squared value of the model.
}
\details{
The arguments `lin_formula`, and `log_formula`
can be unquoted or quoted. The function can handle both forms.

The two datasets (pop_dat and samp_dat) must have the same column names for the domain level,
as well as the predictor variables for the function to work.
}
\examples{
data(pop)
data(samp)

lin_formula <- DRYBIO_AG_TPA_live_ADJ ~ tcc16 + elev

result <- saeczi(samp,
                 pop,
                 lin_formula,
                 log_formula = lin_formula,
                 domain_level = "COUNTYFIPS",
                 mse_est = FALSE)

}
